/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.templatewands.client;

import com.minemaarten.templatewands.items.ItemTemplateWand;
import com.minemaarten.templatewands.network.NetworkHandler;
import com.minemaarten.templatewands.network.PacketChangeRepeatAmount;
import com.minemaarten.templatewands.network.PacketTogglePlacementLock;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;

public class KeyHandler {
    private static final String DESCRIPTION_INC_WAND_REPEAT = "templatewands.template_wand.inc_repeat";
    private static final String DESCRIPTION_DEC_WAND_REPEAT = "templatewands.template_wand.dec_repeat";
    private static final String DESCRIPTION_LOCK_WAND_PLACEMENT = "templatewands.template_wand.lock_placement";
    private static final String CATEGORY = "key.templatewands.category";
    private static KeyHandler INSTANCE = new KeyHandler();
    public KeyBinding keybindIncRepeat;
    public KeyBinding keybindDecRepeat;
    public KeyBinding keybindLockPlacement;
    private final List<KeyBinding> keys = new ArrayList<KeyBinding>();

    public static KeyHandler getInstance() {
        return INSTANCE;
    }

    private KeyHandler() {
        this.keybindIncRepeat = this.registerKeyBinding(new KeyBinding(DESCRIPTION_INC_WAND_REPEAT, 78, CATEGORY));
        this.keybindDecRepeat = this.registerKeyBinding(new KeyBinding(DESCRIPTION_DEC_WAND_REPEAT, 74, CATEGORY));
        this.keybindLockPlacement = this.registerKeyBinding(new KeyBinding(DESCRIPTION_LOCK_WAND_PLACEMENT, 38, CATEGORY));
    }

    private KeyBinding registerKeyBinding(KeyBinding keyBinding) {
        ClientRegistry.registerKeyBinding((KeyBinding)keyBinding);
        this.keys.add(keyBinding);
        return keyBinding;
    }

    @SubscribeEvent
    public void onKey(InputEvent.KeyInputEvent event) {
        for (KeyBinding key : this.keys) {
            if (!key.func_151468_f()) continue;
            this.onKey(key);
        }
    }

    public void onKey(KeyBinding keybinding) {
        if (keybinding == this.keybindIncRepeat) {
            NetworkHandler.sendToServer(new PacketChangeRepeatAmount(true));
        } else if (keybinding == this.keybindDecRepeat) {
            NetworkHandler.sendToServer(new PacketChangeRepeatAmount(false));
        } else if (keybinding == this.keybindLockPlacement) {
            NetworkHandler.sendToServer(new PacketTogglePlacementLock(ItemTemplateWand.getHoveredPos(), Minecraft.func_71410_x().field_71439_g.func_174811_aO()));
        }
    }
}

