/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.templatewands.capabilities;

import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class DefaultCapabilityProvider<TCap>
implements ICapabilitySerializable<NBTBase> {
    private final Capability<TCap> cap;
    private final TCap capInstance;

    public DefaultCapabilityProvider(Capability<TCap> cap) {
        this.cap = cap;
        this.capInstance = cap.getDefaultInstance();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == this.cap;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (this.hasCapability(capability, facing)) {
            return (T)this.capInstance;
        }
        return null;
    }

    public NBTBase serializeNBT() {
        return this.cap.getStorage().writeNBT(this.cap, this.capInstance, null);
    }

    public void deserializeNBT(NBTBase nbt) {
        this.cap.getStorage().readNBT(this.cap, this.capInstance, null, nbt);
    }
}

