/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.templatewands.capabilities;

import com.minemaarten.templatewands.network.NetworkHandler;
import com.minemaarten.templatewands.network.PacketUpdateCapturing;
import com.minemaarten.templatewands.network.PacketUpdateTemplate;
import com.minemaarten.templatewands.templates.IngredientRequirementResult;
import com.minemaarten.templatewands.templates.TemplateCapturer;
import com.minemaarten.templatewands.templates.TemplateSurvival;
import com.minemaarten.templatewands.templates.ingredients.TemplateIngredient;
import java.util.Collections;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CapabilityTemplateWand
implements INBTSerializable<NBTTagCompound> {
    @CapabilityInject(value=CapabilityTemplateWand.class)
    public static Capability<CapabilityTemplateWand> INSTANCE;
    private TemplateCapturer capturer;
    private TemplateSurvival template;

    public void setTemplate(TemplateSurvival template) {
        this.template = template;
        this.capturer = null;
    }

    public TemplateCapturer getCapturer() {
        return this.capturer;
    }

    public TemplateSurvival getTemplate() {
        return this.template;
    }

    public boolean hasTemplate() {
        return this.template != null;
    }

    public void updateCaptureState(BlockPos firstPos, Set<BlockPos> blacklistedPositions) {
        this.capturer = new TemplateCapturer(firstPos);
        this.capturer.blacklistedPositions = blacklistedPositions;
    }

    public void updateLastKnownHoverPos(BlockPos pos) {
        if (this.capturer != null) {
            this.capturer.lastKnownClientPos = pos;
        }
    }

    public void onInterval(World world, EntityPlayer player) {
        if (this.capturer != null) {
            this.capturer.onInterval(world, player);
        }
    }

    public boolean registerCoordinate(World world, BlockPos pos, EntityPlayer player, int maxBlocks) {
        if (this.capturer == null) {
            this.capturer = new TemplateCapturer(pos);
            NetworkHandler.sendTo(new PacketUpdateCapturing(pos, Collections.emptySet()), (EntityPlayerMP)player);
            return true;
        }
        this.template = this.capturer.capture(world, pos, player);
        this.capturer = null;
        if (this.template.field_186272_c.func_177958_n() * this.template.field_186272_c.func_177956_o() * this.template.field_186272_c.func_177952_p() > maxBlocks) {
            this.template = null;
        }
        NetworkHandler.sendTo(new PacketUpdateTemplate(this.template), (EntityPlayerMP)player);
        return this.template != null;
    }

    public void clearTemplate(EntityPlayer player) {
        this.capturer = null;
        this.template = null;
        NetworkHandler.sendTo(new PacketUpdateTemplate(this.template), (EntityPlayerMP)player);
    }

    public void place(World world, BlockPos pos, EntityPlayer player, EnumFacing facing, int repeatAmount) {
        if (this.hasTemplate()) {
            IItemHandler itemHandler = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            for (int i = 0; i < repeatAmount; ++i) {
                IngredientRequirementResult result = this.template.addBlocksToWorld(world, pos, facing, !player.func_184812_l_(), itemHandler);
                if (!result.hasAllRequiredItems()) {
                    player.func_146105_b((ITextComponent)new TextComponentString("Missing:"), false);
                    for (TemplateIngredient<?> ingredient : result.getMissingIngredients()) {
                        player.func_146105_b((ITextComponent)new TextComponentString(ingredient.toString()), false);
                    }
                    return;
                }
                pos = this.template.calculateConnectedPos(pos, facing);
            }
            player.func_146105_b((ITextComponent)new TextComponentString("Template placed"), true);
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        if (this.template != null) {
            tag.func_74757_a("hasTemplate", true);
            this.template.func_189552_a(tag);
        }
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt.func_74767_n("hasTemplate")) {
            this.template = new TemplateSurvival();
            this.template.func_186256_b(nbt);
        } else {
            this.template = null;
        }
    }
}

