/*
 * Decompiled with CFR 0.152.
 */
package com.minemaarten.templatewands;

import com.minemaarten.templatewands.api.TemplateWands;
import com.minemaarten.templatewands.api.blacklist.IBlacklistProvider;
import com.minemaarten.templatewands.api.ingredients.IBlockIngredientProvider;
import com.minemaarten.templatewands.api.ingredients.IEntityIngredientProvider;
import com.minemaarten.templatewands.api.ingredients.IIngredientProvider;
import com.minemaarten.templatewands.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.eventhandler.EventPriority;

public class APIHandler {
    public List<IBlockIngredientProvider> blockIngredientProviders = new ArrayList<IBlockIngredientProvider>();
    public List<IEntityIngredientProvider> entityIngredientProviders = new ArrayList<IEntityIngredientProvider>();
    public List<IBlacklistProvider> blacklistProviders = new ArrayList<IBlacklistProvider>();

    public void initializeAPIImplementors(ASMDataTable asmData) {
        Set allAnnotatedClasses = asmData.getAll(TemplateWands.class.getName());
        for (ASMDataTable.ASMData aSMData : allAnnotatedClasses) {
            try {
                Object provider;
                Class<?> clazz = Class.forName(aSMData.getClassName());
                Log.info("Found class annotating @TemplateWands: " + aSMData.getClassName());
                if (IBlockIngredientProvider.class.isAssignableFrom(clazz)) {
                    provider = (IBlockIngredientProvider)clazz.newInstance();
                    this.addPrioritizedIngredientProvider(this.blockIngredientProviders, provider);
                    Log.info("Successfully registered the IBlockIngredientProvider for \"" + aSMData.getClassName() + "\".");
                }
                if (IEntityIngredientProvider.class.isAssignableFrom(clazz)) {
                    provider = (IEntityIngredientProvider)clazz.newInstance();
                    this.addPrioritizedIngredientProvider(this.entityIngredientProviders, provider);
                    Log.info("Successfully registered the IEntityIngredientProvider for \"" + aSMData.getClassName() + "\".");
                }
                if (!IBlacklistProvider.class.isAssignableFrom(clazz)) continue;
                provider = (IBlacklistProvider)clazz.newInstance();
                this.blacklistProviders.add((IBlacklistProvider)provider);
                Log.info("Successfully registered the IBlacklistProvider for \"" + aSMData.getClassName() + "\".");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                Log.error("Annotated class \"" + aSMData.getClassName() + "\" could not be instantiated, probably because it is not marked public!");
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                Log.error("Annotated class \"" + aSMData.getClassName() + "\" could not be instantiated, probably because it either does not have a constructor without arguments, or because the class is abstract!");
                e.printStackTrace();
            }
        }
        Log.info("Ingredient providers (ordered by priority):");
        for (IBlockIngredientProvider iBlockIngredientProvider : this.blockIngredientProviders) {
            Log.info(iBlockIngredientProvider.getClass().getCanonicalName());
        }
        Log.info("Blacklist providers:");
        for (IBlacklistProvider iBlacklistProvider : this.blacklistProviders) {
            Log.info(iBlacklistProvider.getClass().getCanonicalName());
        }
    }

    private <T extends IIngredientProvider> void addPrioritizedIngredientProvider(List<T> providers, T provider) {
        EventPriority priority = provider.getPriority();
        for (int i = providers.size() - 1; i >= 0; --i) {
            IIngredientProvider other = (IIngredientProvider)providers.get(i);
            if (!this.isLowerOrEqualPriority(priority, other.getPriority())) continue;
            providers.add(i + 1, provider);
            return;
        }
        providers.add(provider);
    }

    private boolean isLowerOrEqualPriority(EventPriority checkingPriority, EventPriority otherPriority) {
        return checkingPriority.ordinal() >= otherPriority.ordinal();
    }
}

