/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.worldofboxes.content.block.box;

import com.builtbroken.worldofboxes.config.ConfigDim;
import com.builtbroken.worldofboxes.content.block.box.BlockDimBox;
import com.builtbroken.worldofboxes.content.block.box.TeleporterSetPos;
import com.builtbroken.worldofboxes.network.PacketHandler;
import com.builtbroken.worldofboxes.network.PacketSyncBox;
import com.builtbroken.worldofboxes.reg.WBBlocks;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class TileEntityDimBox
extends TileEntity
implements ITickable {
    public static final String NBT_TARGET_DIM = "targetDim";
    public static final String NBT_TARGET = "target";
    public static final int ANIMATION_TIMER = 200;
    private static Method copyFromOldField;
    public BlockPos teleportTarget;
    public int teleportDim;
    public boolean isSetup = false;
    public boolean doingSetupAnimation = false;
    public int animationTimer = 0;
    public float animationStep = 0.0f;
    private byte packetTimer = 0;
    private byte updateCheck = 0;

    public boolean isSetup() {
        return this.isSetup;
    }

    public void func_73660_a() {
        if (this.doingSetupAnimation && this.animationTimer-- <= 0) {
            this.doingSetupAnimation = false;
            if (!this.field_145850_b.field_72995_K) {
                this.randomizeDim();
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            byte by = this.packetTimer;
            this.packetTimer = (byte)(by + 1);
            if (by >= 0) {
                this.packetTimer = 0;
                PacketHandler.sendToAllAround(new PacketSyncBox(this), this);
            }
        } else {
            IBlockState state1;
            IBlockState state;
            byte by = this.updateCheck;
            this.updateCheck = (byte)(by + 1);
            if (by >= 5 && (state = this.field_145850_b.func_180495_p(this.func_174877_v())).func_177228_b().containsKey(BlockDimBox.STATE_PROPERTY_ENUM) && state != (state1 = WBBlocks.BOX.func_176221_a(state, (IBlockAccess)this.field_145850_b, this.func_174877_v()))) {
                this.field_145850_b.func_175656_a(this.field_174879_c, state1);
            }
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b(NBT_TARGET_DIM)) {
            this.isSetup = true;
            this.teleportDim = compound.func_74762_e(NBT_TARGET_DIM);
            if (compound.func_74764_b(NBT_TARGET)) {
                int[] array = compound.func_74759_k(NBT_TARGET);
                this.teleportTarget = new BlockPos(array[0], array[1], array[2]);
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (this.isSetup) {
            compound.func_74768_a(NBT_TARGET_DIM, this.teleportDim);
            if (this.teleportTarget != null) {
                compound.func_74783_a(NBT_TARGET, new int[]{this.teleportTarget.func_177958_n(), this.teleportTarget.func_177956_o(), this.teleportTarget.func_177952_p()});
            }
        }
        return super.func_189515_b(compound);
    }

    public void startSetupAnimation() {
        this.doingSetupAnimation = true;
        this.animationTimer = 200;
    }

    public void randomizeDim() {
        try {
            int x = this.field_145850_b.field_73012_v.nextInt(100000) - this.field_145850_b.field_73012_v.nextInt(100000);
            int z = this.field_145850_b.field_73012_v.nextInt(100000) - this.field_145850_b.field_73012_v.nextInt(100000);
            int y = 100;
            this.teleportTarget = new BlockPos(x, y, z);
            int targetDim = this.field_145850_b.field_73011_w.getDimension() == ConfigDim.dimID ? 0 : ConfigDim.dimID;
            WorldServer targetWorld = DimensionManager.getWorld((int)targetDim);
            if (targetWorld != null) {
                targetWorld.func_180495_p(this.teleportTarget);
                RayTraceResult result = targetWorld.func_147447_a(new Vec3d((double)x, 255.0, (double)z), new Vec3d((double)x, 0.0, (double)z), false, true, true);
                if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK) {
                    y = result.func_178782_a().func_177956_o() + 1;
                    BlockPos pos = new BlockPos(x, y, z);
                    while (!targetWorld.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)targetWorld, pos)) {
                        pos = new BlockPos(x, ++y, z);
                    }
                    targetWorld.func_175656_a(pos, WBBlocks.BOX.func_176223_P());
                    TileEntity tile = targetWorld.func_175625_s(pos);
                    if (tile instanceof TileEntityDimBox) {
                        ((TileEntityDimBox)tile).setTarget(this.field_145850_b.field_73011_w.getDimension(), this.func_174877_v().func_177984_a());
                    }
                    this.teleportTarget = pos.func_177984_a();
                    this.setTarget(targetDim, this.teleportTarget);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.isSetup = false;
            this.teleportTarget = null;
        }
    }

    public void setTarget(int dim, BlockPos teleportTarget) {
        this.teleportDim = dim;
        this.teleportTarget = teleportTarget;
        this.isSetup = true;
    }

    public BlockPos getTeleportTarget() {
        return this.teleportTarget;
    }

    public void teleport(EntityPlayerMP player) {
        if (this.isSetup()) {
            int oldDimension = player.func_130014_f_().field_73011_w.getDimension();
            MinecraftServer server = player.func_130014_f_().func_73046_m();
            WorldServer worldServer = server.func_71218_a(this.teleportDim);
            if (worldServer != null && worldServer.func_73046_m() != null) {
                player.func_82242_a(0);
                worldServer.func_73046_m().func_184103_al().transferPlayerToDimension(player, this.teleportDim, (Teleporter)new TeleporterSetPos(worldServer, this.getTeleportTarget()));
                player.func_70634_a((double)this.getTeleportTarget().func_177958_n(), (double)this.getTeleportTarget().func_177956_o(), (double)this.getTeleportTarget().func_177952_p());
                if (oldDimension == 1) {
                    player.func_70634_a((double)this.getTeleportTarget().func_177958_n(), (double)this.getTeleportTarget().func_177956_o(), (double)this.getTeleportTarget().func_177952_p());
                    worldServer.func_72838_d((Entity)player);
                    worldServer.func_72866_a((Entity)player, false);
                }
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString("Error: Failed to locate dimension [" + this.teleportDim + "] to send you to!!!"));
            }
        }
    }

    private void copyDateFromOld(Entity entity, Entity oldEntity) {
        if (copyFromOldField == null) {
            try {
                copyFromOldField = Entity.class.getDeclaredMethod("copyDataFromOld", Entity.class);
                copyFromOldField.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        if (copyFromOldField != null) {
            try {
                copyFromOldField.invoke((Object)entity, oldEntity);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isDoingSetupAnimation() {
        return this.doingSetupAnimation;
    }
}

