/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.worldofboxes.content.block.box;

import com.builtbroken.worldofboxes.content.block.box.TileEntityDimBox;
import java.awt.Color;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.util.glu.Sphere;

public class TESRBox
extends TileEntitySpecialRenderer<TileEntityDimBox> {
    private static final ResourceLocation END_SKY_TEXTURE = new ResourceLocation("textures/environment/end_sky.png");
    private static final ResourceLocation END_PORTAL_TEXTURE = new ResourceLocation("textures/entity/end_portal.png");
    private static final Random RANDOM = new Random(31100L);
    private static final FloatBuffer MODELVIEW = GLAllocation.func_74529_h((int)16);
    private static final FloatBuffer PROJECTION = GLAllocation.func_74529_h((int)16);
    private final FloatBuffer buffer = GLAllocation.func_74529_h((int)16);
    public static List<Color> randomColorsForBeams = new ArrayList<Color>();
    public Color colorIn = new Color(0xFFFFFF);

    public void render(TileEntityDimBox te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (te.isSetup()) {
            te.animationStep = 0.0f;
            this.renderPortal(te, x, y, z, partialTicks, destroyStage, alpha);
        } else if (te.isDoingSetupAnimation()) {
            float step = -partialTicks * 0.01f;
            if (te.animationTimer > 100) {
                step = -step * 0.5f;
            }
            te.animationStep += step;
            te.animationStep = Math.max(te.animationStep, 0.0f);
            te.animationStep = Math.min(te.animationStep, 1.0f);
            this.renderBeams(te, x + 0.5, y + (double)te.animationStep + 0.5, z + 0.5, 0.02f, te.animationStep);
            this.renderSphere(te, x + 0.5, y + (double)te.animationStep + 0.5, z + 0.5, 0.1f);
        } else {
            te.animationStep = 0.0f;
        }
    }

    float lerp(float point1, float point2, float alpha) {
        return point1 + alpha * (point2 - point1);
    }

    protected void renderPortal(TileEntityDimBox te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        GlStateManager.func_179140_f();
        RANDOM.setSeed(31100L);
        GlStateManager.func_179111_a((int)2982, (FloatBuffer)MODELVIEW);
        GlStateManager.func_179111_a((int)2983, (FloatBuffer)PROJECTION);
        double d0 = x * x + y * y + z * z;
        int i = this.getPasses(d0);
        float f = this.getOffset();
        boolean flag = false;
        for (int j = 0; j < i; ++j) {
            GlStateManager.func_179094_E();
            float f1 = 2.0f / (float)(18 - j);
            if (j == 0) {
                this.func_147499_a(END_SKY_TEXTURE);
                f1 = 0.15f;
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            }
            if (j >= 1) {
                this.func_147499_a(END_PORTAL_TEXTURE);
                flag = true;
                Minecraft.func_71410_x().field_71460_t.func_191514_d(true);
            }
            if (j == 1) {
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            }
            GlStateManager.func_179149_a((GlStateManager.TexGen)GlStateManager.TexGen.S, (int)9216);
            GlStateManager.func_179149_a((GlStateManager.TexGen)GlStateManager.TexGen.T, (int)9216);
            GlStateManager.func_179149_a((GlStateManager.TexGen)GlStateManager.TexGen.R, (int)9216);
            GlStateManager.func_179105_a((GlStateManager.TexGen)GlStateManager.TexGen.S, (int)9474, (FloatBuffer)this.getBuffer(1.0f, 0.0f, 0.0f, 0.0f));
            GlStateManager.func_179105_a((GlStateManager.TexGen)GlStateManager.TexGen.T, (int)9474, (FloatBuffer)this.getBuffer(0.0f, 1.0f, 0.0f, 0.0f));
            GlStateManager.func_179105_a((GlStateManager.TexGen)GlStateManager.TexGen.R, (int)9474, (FloatBuffer)this.getBuffer(0.0f, 0.0f, 1.0f, 0.0f));
            GlStateManager.func_179087_a((GlStateManager.TexGen)GlStateManager.TexGen.S);
            GlStateManager.func_179087_a((GlStateManager.TexGen)GlStateManager.TexGen.T);
            GlStateManager.func_179087_a((GlStateManager.TexGen)GlStateManager.TexGen.R);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179096_D();
            GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.0f);
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
            float f2 = j + 1;
            GlStateManager.func_179109_b((float)(17.0f / f2), (float)((2.0f + f2 / 1.5f) * ((float)Minecraft.func_71386_F() % 800000.0f / 800000.0f)), (float)0.0f);
            GlStateManager.func_179114_b((float)((f2 * f2 * 4321.0f + f2 * 9.0f) * 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179152_a((float)(4.5f - f2 / 4.0f), (float)(4.5f - f2 / 4.0f), (float)1.0f);
            GlStateManager.func_179110_a((FloatBuffer)PROJECTION);
            GlStateManager.func_179110_a((FloatBuffer)MODELVIEW);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            float f3 = (RANDOM.nextFloat() * 0.5f + 0.1f) * f1;
            float f4 = (RANDOM.nextFloat() * 0.5f + 0.4f) * f1;
            float f5 = (RANDOM.nextFloat() * 0.5f + 0.5f) * f1;
            bufferbuilder.func_181662_b(x, y + (double)f, z + 1.0).func_181666_a(f3, f4, f5, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b(x + 1.0, y + (double)f, z + 1.0).func_181666_a(f3, f4, f5, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b(x + 1.0, y + (double)f, z).func_181666_a(f3, f4, f5, 1.0f).func_181675_d();
            bufferbuilder.func_181662_b(x, y + (double)f, z).func_181666_a(f3, f4, f5, 1.0f).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
            this.func_147499_a(END_SKY_TEXTURE);
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179100_b((GlStateManager.TexGen)GlStateManager.TexGen.S);
        GlStateManager.func_179100_b((GlStateManager.TexGen)GlStateManager.TexGen.T);
        GlStateManager.func_179100_b((GlStateManager.TexGen)GlStateManager.TexGen.R);
        GlStateManager.func_179145_e();
        if (flag) {
            Minecraft.func_71410_x().field_71460_t.func_191514_d(false);
        }
    }

    public void renderBeams(TileEntityDimBox te, double x, double y, double z, float sizeScale, float timeScale) {
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        RenderHelper.func_74518_a();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
        GlStateManager.func_179090_x();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)1);
        GlStateManager.func_179118_c();
        GlStateManager.func_179089_o();
        GlStateManager.func_179097_i();
        Random redmatterBeamRandom = new Random(432L);
        int beamCount = (int)((timeScale + timeScale * timeScale) / 2.0f * 60.0f);
        for (int beamIndex = 0; beamIndex < beamCount; ++beamIndex) {
            Color colorOut;
            GlStateManager.func_179094_E();
            float beamLength = (redmatterBeamRandom.nextFloat() * 20.0f + 5.0f) * sizeScale;
            float beamWidth = (redmatterBeamRandom.nextFloat() * 2.0f + 1.0f) * sizeScale;
            GlStateManager.func_179114_b((float)(redmatterBeamRandom.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(redmatterBeamRandom.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(redmatterBeamRandom.nextFloat() * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)(redmatterBeamRandom.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(redmatterBeamRandom.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(redmatterBeamRandom.nextFloat() * 360.0f + timeScale * 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            Color colorIn = this.colorIn;
            if (beamIndex < randomColorsForBeams.size()) {
                colorOut = randomColorsForBeams.get(beamIndex);
            } else {
                colorOut = new Color(redmatterBeamRandom.nextFloat(), redmatterBeamRandom.nextFloat(), redmatterBeamRandom.nextFloat());
                randomColorsForBeams.add(colorOut);
            }
            bufferbuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            bufferbuilder.func_181662_b(0.0, 0.0, 0.0).func_181669_b(colorIn.getRed(), colorIn.getGreen(), colorIn.getBlue(), colorIn.getAlpha()).func_181675_d();
            bufferbuilder.func_181662_b(-0.866 * (double)beamWidth, (double)beamLength, (double)(-0.5f * beamWidth)).func_181669_b(colorOut.getRed(), colorOut.getGreen(), colorOut.getBlue(), colorOut.getAlpha()).func_181675_d();
            bufferbuilder.func_181662_b(0.866 * (double)beamWidth, (double)beamLength, (double)(-0.5f * beamWidth)).func_181669_b(colorOut.getRed(), colorOut.getGreen(), colorOut.getBlue(), colorOut.getAlpha()).func_181675_d();
            bufferbuilder.func_181662_b(0.0, (double)beamLength, (double)(1.0f * beamWidth)).func_181669_b(colorOut.getRed(), colorOut.getGreen(), colorOut.getBlue(), colorOut.getAlpha()).func_181675_d();
            bufferbuilder.func_181662_b(-0.866 * (double)beamWidth, (double)beamLength, (double)(-0.5f * beamWidth)).func_181669_b(colorOut.getRed(), colorOut.getGreen(), colorOut.getBlue(), colorOut.getAlpha()).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179126_j();
        GlStateManager.func_179129_p();
        GlStateManager.func_179084_k();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179141_d();
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
    }

    public void renderSphere(TileEntityDimBox te, double x, double y, double z, float radius) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
        this.func_147499_a(END_SKY_TEXTURE);
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        new Sphere().draw(radius * 0.8f, 32, 32);
        GlStateManager.func_179121_F();
        float ticks = te.animationTimer % 40;
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
        this.func_147499_a(END_PORTAL_TEXTURE);
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.2f, (float)0.8f);
        float scaleSize = 5.0E-4f;
        float fullSize = radius * 5.0E-4f * 20.0f;
        float scaleDelta = ticks > 20.0f ? fullSize - radius * 5.0E-4f * (ticks - 20.0f) : radius * 5.0E-4f * ticks;
        new Sphere().draw(radius + scaleDelta, 32, 32);
        GlStateManager.func_179126_j();
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        RenderHelper.func_74519_b();
    }

    protected int getPasses(double p_191286_1_) {
        int i = p_191286_1_ > 36864.0 ? 1 : (p_191286_1_ > 25600.0 ? 3 : (p_191286_1_ > 16384.0 ? 5 : (p_191286_1_ > 9216.0 ? 7 : (p_191286_1_ > 4096.0 ? 9 : (p_191286_1_ > 1024.0 ? 11 : (p_191286_1_ > 576.0 ? 13 : (p_191286_1_ > 256.0 ? 14 : 15)))))));
        return i;
    }

    protected float getOffset() {
        return 0.75f;
    }

    private FloatBuffer getBuffer(float p_147525_1_, float p_147525_2_, float p_147525_3_, float p_147525_4_) {
        this.buffer.clear();
        this.buffer.put(p_147525_1_).put(p_147525_2_).put(p_147525_3_).put(p_147525_4_);
        this.buffer.flip();
        return this.buffer;
    }
}

