/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.worldofboxes.content.block.box;

import com.builtbroken.worldofboxes.content.block.box.TileEntityDimBox;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockDimBox
extends Block
implements ITileEntityProvider {
    public static final PropertyDirection FACING_PROPERTY = PropertyDirection.func_177714_a((String)"facing");
    public static final PropertyEnum<State> STATE_PROPERTY_ENUM = PropertyEnum.func_177709_a((String)"state", State.class);

    public BlockDimBox() {
        super(Material.field_151575_d);
        this.func_180632_j(this.func_176223_P().func_177226_a(STATE_PROPERTY_ENUM, (Comparable)((Object)State.CLOSED)));
        this.setRegistryName("worldofboxes", "box");
        this.func_149663_c("worldofboxes:box");
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.func_149711_c(50.0f);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K && playerIn instanceof EntityPlayerMP && !playerIn.func_70093_af()) {
            boolean isAboveClear;
            RayTraceResult result = worldIn.func_72933_a(new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.1, (double)pos.func_177952_p() + 0.5), new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 3.9, (double)pos.func_177952_p() + 0.5));
            boolean bl = isAboveClear = result == null || result.field_72313_a == RayTraceResult.Type.MISS;
            if (isAboveClear) {
                TileEntity tile = worldIn.func_175625_s(pos);
                if (tile instanceof TileEntityDimBox) {
                    if (!((TileEntityDimBox)tile).isSetup()) {
                        if (!((TileEntityDimBox)tile).isDoingSetupAnimation()) {
                            playerIn.func_145747_a((ITextComponent)new TextComponentString("TheBox: Generating boxes inside of boxes, comprised of boxes made from boxes.... to create a world of boxes."));
                            ((TileEntityDimBox)tile).startSetupAnimation();
                        }
                    } else {
                        ((TileEntityDimBox)tile).teleport((EntityPlayerMP)playerIn);
                    }
                }
            } else {
                playerIn.func_145747_a((ITextComponent)new TextComponentString("Zoidberg: The box says no..."));
                playerIn.func_145747_a((ITextComponent)new TextComponentString("TheBox: Clear 3 blocks above to open \\0/"));
            }
        }
        return true;
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityDimBox();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING_PROPERTY, STATE_PROPERTY_ENUM});
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING_PROPERTY, (Comparable)placer.func_174811_aO());
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING_PROPERTY, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING_PROPERTY)).func_176745_a();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityDimBox) {
            if (((TileEntityDimBox)tile).isSetup()) {
                return state.func_177226_a(STATE_PROPERTY_ENUM, (Comparable)((Object)State.OPEN));
            }
            if (((TileEntityDimBox)tile).isDoingSetupAnimation()) {
                return state.func_177226_a(STATE_PROPERTY_ENUM, (Comparable)((Object)State.NO_TOP));
            }
            return state.func_177226_a(STATE_PROPERTY_ENUM, (Comparable)((Object)State.CLOSED));
        }
        return state;
    }

    public static enum State implements IStringSerializable
    {
        CLOSED,
        OPEN,
        NO_TOP;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }
}

