/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.worldofboxes.client;

import com.builtbroken.worldofboxes.client.world.SkyBoxRenderBox;
import com.builtbroken.worldofboxes.content.block.BlockCBTallGrass;
import com.builtbroken.worldofboxes.content.block.box.TESRBox;
import com.builtbroken.worldofboxes.content.block.box.TileEntityDimBox;
import com.builtbroken.worldofboxes.reg.WBBlocks;
import com.builtbroken.worldofboxes.world.BoxWorldProvider;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="worldofboxes")
public final class RenderReg {
    public static final Random random = new Random();

    @SubscribeEvent
    public static void registerBlockColors(ColorHandlerEvent.Block event) {
        event.getBlockColors().func_186722_a(new IBlockColor(){

            public int func_186720_a(IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
                int color = worldIn != null && pos != null ? BiomeColorHelper.func_180286_a((IBlockAccess)worldIn, (BlockPos)pos) : ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
                return color + (worldIn != null ? random.nextInt(100) : 0);
            }
        }, new Block[]{WBBlocks.GRASS});
        event.getBlockColors().func_186722_a(new IBlockColor(){

            public int func_186720_a(IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
                BlockPlanks.EnumType type = (BlockPlanks.EnumType)state.func_177229_b((IProperty)BlockOldLeaf.field_176239_P);
                int color = type == BlockPlanks.EnumType.SPRUCE ? ColorizerFoliage.func_77466_a() : (type == BlockPlanks.EnumType.BIRCH ? ColorizerFoliage.func_77469_b() : (worldIn != null && pos != null ? BiomeColorHelper.func_180287_b((IBlockAccess)worldIn, (BlockPos)pos) : ColorizerFoliage.func_77468_c()));
                return color + (worldIn != null ? random.nextInt(100) : 0);
            }
        }, new Block[]{WBBlocks.LEAF});
        event.getBlockColors().func_186722_a(new IBlockColor(){

            public int func_186720_a(IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
                return worldIn != null && pos != null ? BiomeColorHelper.func_180287_b((IBlockAccess)worldIn, (BlockPos)pos) : ColorizerFoliage.func_77468_c();
            }
        }, new Block[]{WBBlocks.LEAF2});
        event.getBlockColors().func_186722_a(new IBlockColor(){

            public int func_186720_a(IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
                int color = worldIn != null && pos != null ? BiomeColorHelper.func_180286_a((IBlockAccess)worldIn, (BlockPos)pos) : (state.func_177229_b(BlockCBTallGrass.TYPE) == BlockCBTallGrass.EnumType.DEAD_BUSH ? 0xFFFFFF : ColorizerGrass.func_77480_a((double)0.5, (double)1.0));
                return color + (worldIn != null ? random.nextInt(100) : 0);
            }
        }, new Block[]{WBBlocks.TALL_GRASS});
    }

    @SubscribeEvent
    public static void registerItemColors(final ColorHandlerEvent.Item event) {
        event.getItemColors().func_186731_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                IBlockState iblockstate = ((ItemBlock)stack.func_77973_b()).func_179223_d().func_176203_a(stack.func_77960_j());
                return event.getBlockColors().func_186724_a(iblockstate, (IBlockAccess)null, (BlockPos)null, tintIndex);
            }
        }, new Block[]{WBBlocks.LEAF, WBBlocks.LEAF2, WBBlocks.TALL_GRASS, WBBlocks.GRASS});
    }

    @SubscribeEvent
    public static void registerAllModels(ModelRegistryEvent event) {
        RenderReg.addItemRender(WBBlocks.BOX);
        RenderReg.addItemSubtypesRender((Block)WBBlocks.LOG, 0, 3);
        RenderReg.addItemSubtypesRender((Block)WBBlocks.LOG2, 0, 1);
        RenderReg.addItemSubtypesRender((Block)WBBlocks.LEAF, 0, 3);
        RenderReg.addItemSubtypesRender((Block)WBBlocks.LEAF2, 0, 1);
        RenderReg.addItemRender(WBBlocks.GRASS);
        RenderReg.addItemSubtypesRender(WBBlocks.TALL_GRASS, 0, 2);
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityDimBox.class, (TileEntitySpecialRenderer)new TESRBox());
    }

    private static void addItemRender(Block block) {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName(), "inventory"));
    }

    private static void addItemSubtypesRender(Block block, int min, int max) {
        Item item = Item.func_150898_a((Block)block);
        final ResourceLocation name = block.getRegistryName();
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new DefaultStateMapper(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return new ModelResourceLocation(name, this.func_178131_a((Map)state.func_177228_b()));
            }
        });
        for (int i = min; i <= max; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(name, RenderReg.getPropertyString(block.func_176203_a(i).func_177228_b(), new String[0])));
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld().field_73011_w instanceof BoxWorldProvider) {
            event.getWorld().field_73011_w.setSkyRenderer((IRenderHandler)new SkyBoxRenderBox());
        }
    }

    public static String getPropertyString(Map<IProperty<?>, Comparable<?>> values, String ... extrasArgs) {
        StringBuilder stringbuilder = new StringBuilder();
        for (Map.Entry<IProperty<?>, Comparable<?>> entry : values.entrySet()) {
            if (stringbuilder.length() != 0) {
                stringbuilder.append(",");
            }
            IProperty<?> iproperty = entry.getKey();
            stringbuilder.append(iproperty.func_177701_a());
            stringbuilder.append("=");
            stringbuilder.append(RenderReg.getPropertyName(iproperty, entry.getValue()));
        }
        if (stringbuilder.length() == 0) {
            stringbuilder.append("inventory");
        }
        for (String args : extrasArgs) {
            if (stringbuilder.length() != 0) {
                stringbuilder.append(",");
            }
            stringbuilder.append(args);
        }
        return stringbuilder.toString();
    }

    private static <T extends Comparable<T>> String getPropertyName(IProperty<T> property, Comparable<?> comparable) {
        return property.func_177702_a(comparable);
    }
}

