/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.monkmod.levels;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.rwtema.monkmod.abilities.Abilities;
import com.rwtema.monkmod.abilities.MonkAbility;
import com.rwtema.monkmod.advancements.MonkRequirement;
import com.rwtema.monkmod.advancements.criteria.MonkRequirementArrow;
import com.rwtema.monkmod.advancements.criteria.MonkRequirementBedrockSleep;
import com.rwtema.monkmod.advancements.criteria.MonkRequirementBreakBlockBareHanded;
import com.rwtema.monkmod.advancements.criteria.MonkRequirementDescentAscent;
import com.rwtema.monkmod.advancements.criteria.MonkRequirementEnemyDefeat;
import com.rwtema.monkmod.advancements.criteria.MonkRequirementFall;
import com.rwtema.monkmod.advancements.criteria.MonkRequirementKill;
import com.rwtema.monkmod.advancements.criteria.MonkRequirementKissCreeper;
import com.rwtema.monkmod.advancements.criteria.MonkRequirementMeditateEndermen;
import com.rwtema.monkmod.advancements.criteria.MonkRequirementOcean;
import com.rwtema.monkmod.advancements.criteria.MonkRequirementPet;
import com.rwtema.monkmod.advancements.criteria.MonkRequirementStare;
import com.rwtema.monkmod.advancements.criteria.MonkRequirementSunriseSunset;
import com.rwtema.monkmod.advancements.criteria.MonkRequirementWalk;
import com.rwtema.monkmod.advancements.criteria.MonkRequirementWaterMeditation;
import com.rwtema.monkmod.levels.MonkLevelManager;
import java.util.HashMap;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class MonkLevels {
    public static final HashMap<Integer, MonkRequirement> levelUpRequirements = new HashMap();
    public HashMultimap<Integer, MonkAbility> abilityHashMultimap = HashMultimap.create();

    public static void init() {
        MonkLevels monkLevels = new MonkLevels();
        monkLevels.loadAbilities();
        monkLevels.abilityHashMultimap.keySet().stream().sorted().forEach(level -> {
            for (MonkAbility monkAbility : monkLevels.abilityHashMultimap.get(level)) {
                int ability_level = 0;
                for (int i = 0; i < level; ++i) {
                    if (!monkLevels.abilityHashMultimap.get((Object)i).contains(monkAbility)) continue;
                    ++ability_level;
                }
                try {
                    MonkLevelManager.register(level, monkAbility, ability_level);
                }
                catch (Exception err) {
                    throw new RuntimeException("Unable to register: " + level + " " + monkAbility.name + " " + ability_level, err);
                }
            }
        });
    }

    public void register(int level, MonkAbility ... monkAbilities) {
        this.abilityHashMultimap.putAll((Object)level, (Iterable)ImmutableList.copyOf((Object[])monkAbilities));
    }

    public void loadAbilities() {
        this.registerRequirement(new MonkRequirementBreakBlockBareHanded(0, (world, pos, state) -> state.func_177230_c().isWood((IBlockAccess)world, pos), 1));
        this.register(1, Abilities.MINING, Abilities.STRENGTH);
        this.registerRequirement(new MonkRequirementBreakBlockBareHanded(1, (world, pos, state) -> state.func_177230_c().isWood((IBlockAccess)world, pos), 10));
        this.register(2, Abilities.HUNGER);
        this.register(2, Abilities.ARMOR);
        this.registerRequirement(new MonkRequirementSunriseSunset(2, 200));
        this.register(3, Abilities.WATER_BREATHING);
        this.register(3, Abilities.ARMOR);
        this.registerRequirement(new MonkRequirementOcean(3, 20.0));
        this.registerRequirement(new MonkRequirementBreakBlockBareHanded(4, (world, pos, state) -> state.func_177230_c() == Blocks.field_150348_b, 5));
        this.register(4, Abilities.MINING);
        this.register(4, Abilities.ARMOR, Abilities.STRENGTH);
        this.registerRequirement(new MonkRequirementPet(5));
        this.register(5, Abilities.PET);
        this.registerRequirement(new MonkRequirementWalk(6, 100.0){

            @Override
            public boolean satisfiesRequirements(EntityPlayerMP player) {
                return player.func_70051_ag() && super.satisfiesRequirements(player);
            }
        });
        this.register(6, Abilities.SPEED, Abilities.JUMP);
        this.registerRequirement(new MonkRequirementKill(7, 5){

            @Override
            protected boolean isValidEntity(LivingDeathEvent event) {
                return event.getEntityLiving().func_70662_br();
            }
        });
        this.register(7, Abilities.STRENGTH);
        this.register(7, Abilities.ARMOR);
        this.registerRequirement(new MonkRequirementBreakBlockBareHanded(8, (world, pos, state) -> state.func_177230_c() == Blocks.field_150339_S, 1));
        this.register(8, Abilities.MINING, Abilities.STRENGTH);
        this.registerRequirement(new MonkRequirementWalk(9, 10.0){

            @Override
            protected void onGrant(EntityPlayerMP player) {
                player.func_70066_B();
                player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 200, 2));
            }

            @Override
            public boolean satisfiesRequirements(EntityPlayerMP player) {
                return (player.func_70045_F() || player.func_70027_ad()) && player.field_70170_p.func_147470_e(player.func_174813_aQ()) && super.satisfiesRequirements(player);
            }
        });
        this.register(9, Abilities.FIRE);
        this.register(9, Abilities.ARMOR, Abilities.SPEED);
        this.registerRequirement(new MonkRequirementBreakBlockBareHanded(10, (world, pos, state) -> state.func_177230_c() == Blocks.field_150343_Z, 1));
        this.register(10, Abilities.MINING);
        this.register(10, Abilities.ARMOR, Abilities.STRENGTH);
        this.registerRequirement(new MonkRequirementFall(11));
        this.register(11, Abilities.SPEED, Abilities.HEALTH, Abilities.FEATHER_FALLING);
        this.registerRequirement(new MonkRequirementKissCreeper(12));
        this.register(12, Abilities.EXPLOSION, Abilities.KISS, Abilities.HEALTH);
        this.registerRequirement(new MonkRequirementArrow(13, 5));
        this.register(13, Abilities.ARROW_CATCH, Abilities.HEALTH);
        this.registerRequirement(new MonkRequirementWaterMeditation(14, 200));
        this.register(14, Abilities.WALK_ON_WATER);
        this.registerRequirement(new MonkRequirementStare(15));
        this.register(15, Abilities.WITHERING_STARE, Abilities.HEALTH);
        this.registerRequirement(new MonkRequirementMeditateEndermen(16, 3600));
        this.register(16, Abilities.BLINK);
        this.registerRequirement(new MonkRequirementBedrockSleep(17));
        this.register(17, Abilities.BLIND, Abilities.MINING, Abilities.STRENGTH);
        this.registerRequirement(new MonkRequirementKill(18, 5){

            @Override
            protected boolean isValidEntity(LivingDeathEvent event) {
                return event.getEntity() instanceof IMob;
            }

            @Override
            protected void onGrant(EntityPlayerMP player) {
                super.onGrant(player);
                player.func_184589_d(MobEffects.field_76440_q);
            }
        });
        this.register(18, Abilities.BLIND, Abilities.HUNGER, Abilities.ARMOR, Abilities.HEALTH);
        this.registerRequirement(new MonkRequirementEnemyDefeat<EntityWither>(19, EntityWither.class));
        this.register(19, Abilities.POTION_IMMUNITY);
        this.registerRequirement(new MonkRequirementDescentAscent(20));
        this.register(20, Abilities.FLY);
    }

    private void registerRequirement(MonkRequirement requirement) {
        levelUpRequirements.merge(requirement.levelToGrant, requirement, (monkRequirement, monkRequirement2) -> {
            throw new RuntimeException("Duplicate levels");
        });
    }
}

