/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.monkmod.levels;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.rwtema.monkmod.abilities.MonkAbility;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang3.Validate;

public class MonkLevelManager {
    private static final HashMultimap<Integer, Entry> abilities = HashMultimap.create();
    private static HashMap<Integer, Map<MonkAbility, Integer>> cachedAbilities = null;

    public static void register(int level, MonkAbility ability, int abilitiy_level) {
        Validate.isTrue((abilitiy_level < ability.maxlevel ? 1 : 0) != 0);
        cachedAbilities = null;
        abilities.put((Object)level, (Object)new Entry(ability, abilitiy_level));
    }

    public static Map<MonkAbility, Integer> getAbilities(int level) {
        HashMap<Integer, Map<MonkAbility, Integer>> cachedAbilities = MonkLevelManager.cachedAbilities;
        if (cachedAbilities == null) {
            cachedAbilities = new HashMap();
            HashMap<MonkAbility, Integer> levels = new HashMap<MonkAbility, Integer>();
            for (int i = 0; i <= 20; ++i) {
                for (Entry entry : abilities.get((Object)i)) {
                    levels.merge(entry.ability, entry.level, Math::max);
                }
                cachedAbilities.put(i, (Map<MonkAbility, Integer>)ImmutableMap.copyOf(levels));
            }
        }
        level = MathHelper.func_76125_a((int)level, (int)0, (int)20);
        return cachedAbilities.get(level);
    }

    public static class Entry {
        public final MonkAbility ability;
        public final int level;

        public Entry(MonkAbility ability, int level) {
            this.ability = ability;
            this.level = level;
        }
    }
}

