/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.monkmod.debug;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import com.rwtema.monkmod.MonkMod;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.Validate;

public class CreateJSons {
    public static void create() {
        CreateJSons.createAdvancements();
        CreateJSons.createItemModels();
        ArrayList<String> strings = new ArrayList<String>();
        for (int i = 0; i <= 20; ++i) {
            strings.add("monk.advancements.level." + i + "=Monk Level " + i);
            strings.add("monk.advancements.level." + i + ".desc=");
            strings.add("monk.advancements.reward." + i + "=Awakened Skills: " + i);
            strings.add("monk.advancements.reward." + i + ".desc=");
        }
        MonkMod.logger.info("\n" + strings.stream().collect(Collectors.joining("\n")));
    }

    private static void createItemModels() {
        File dir = new File("C:\\extrautils\\modjam2018\\src\\main\\resources\\assets\\monk\\models\\item");
        for (int level = 0; level <= 21; ++level) {
            CreateJSons.writeJSon(new File(dir, ((ResourceLocation)Validate.notNull((Object)MonkMod.ITEM_MONK_BASE.getRegistryName())).func_110623_a() + "_" + level + ".json"), CreateJSons.json().add("parent", "item/generated").add("textures", CreateJSons.json().add("layer0", "monk:monk_level_icon_" + level)).build());
        }
    }

    private static void createAdvancements() {
        File dir = new File("C:\\extrautils\\modjam2018\\src\\main\\resources\\assets\\monk\\advancements\\monk");
        CreateJSons.writeJSon(new File(dir, "root.json"), CreateJSons.json().add("display", CreateJSons.json().add("icon", CreateJSons.json().add("item", ((ResourceLocation)Validate.notNull((Object)MonkMod.ITEM_MONK_BASE.getRegistryName())).toString()).add("data", 0)).add("title", CreateJSons.json().add("translate", "monk.advancements.level.0")).add("description", CreateJSons.json().add("translate", "monk.advancements.level.0.desc")).add("background", "monk:textures/advancements/advancement_background.png").add("show_toast", true).add("announce_to_chat", false).add("hidden", false)).add("criteria", CreateJSons.json().add("level", CreateJSons.json().add("trigger", "monk:levelup").add("conditions", CreateJSons.json().add("level", 0)))).build());
        for (int level = 1; level <= 20; ++level) {
            CreateJSons.writeJSon(new File(dir, "level_" + level + ".json"), CreateJSons.json().add("display", CreateJSons.json().add("icon", CreateJSons.json().add("item", ((ResourceLocation)Validate.notNull((Object)MonkMod.ITEM_MONK_BASE.getRegistryName())).toString()).add("data", level)).add("title", CreateJSons.json().add("translate", "monk.advancements.level." + level)).add("description", CreateJSons.json().add("translate", "monk.advancements.level." + level + ".desc")).add("show_toast", true).add("announce_to_chat", true).add("hidden", false)).add("parent", level == 1 ? "monk:monk/root" : "monk:monk/level_" + (level - 1)).add("criteria", CreateJSons.json().add("level", CreateJSons.json().add("trigger", "monk:levelup").add("conditions", CreateJSons.json().add("level", level)))).build());
            CreateJSons.writeJSon(new File(dir, "level_reward_" + level + ".json"), CreateJSons.json().add("display", CreateJSons.json().add("icon", CreateJSons.json().add("item", ((ResourceLocation)Validate.notNull((Object)MonkMod.ITEM_MONK_BASE.getRegistryName())).toString()).add("data", 21)).add("title", CreateJSons.json().add("translate", "monk.advancements.reward." + level)).add("description", CreateJSons.json().add("translate", "monk.advancements.reward." + level + ".desc")).add("show_toast", false).add("announce_to_chat", false).add("hidden", true)).add("parent", level == 1 ? "monk:monk/root" : "monk:monk/level_" + (level - 1)).add("criteria", CreateJSons.json().add("level", CreateJSons.json().add("trigger", "monk:levelup").add("conditions", CreateJSons.json().add("level", level)))).build());
        }
    }

    private static void writeJSon(@Nonnull File file, JsonObject model) {
        try (FileWriter writer = new FileWriter(file.getPath());){
            JsonWriter jsonWriter = new JsonWriter((Writer)writer);
            jsonWriter.setIndent("  ");
            jsonWriter.setLenient(true);
            Streams.write((JsonElement)model, (JsonWriter)jsonWriter);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static JSonObjBuilder json() {
        return new JSonObjBuilder();
    }

    public class AdvDummy {
        DisplayDummy display;
        HashMap<String, CriteriaDummy> criteria = new HashMap();

        public AdvDummy(int level) {
            this.display = new DisplayDummy();
            this.display.icon.data = level;
            this.display.title.translate = "monk.advancements.level." + level;
            this.display.description.translate = "monk.advancements.level." + level + ".desc";
            this.display.parent = level == 1 ? "monk:monk/root" : "monk:monk/level_" + level;
            CriteriaDummy criteriaDummy = new CriteriaDummy();
            criteriaDummy.level = level;
            this.criteria = Maps.newHashMap();
            this.criteria.put("level", criteriaDummy);
        }

        public class CriteriaDummy {
            String trigger = "monk:levelup";
            int level;
        }

        public class DisplayDummy {
            ItemDummy icon = new ItemDummy();
            StringDummy title = new StringDummy();
            StringDummy description = new StringDummy();
            String parent;
            boolean show_toast = true;
            boolean announce_to_chat = true;

            public class StringDummy {
                String translate;
            }

            public class ItemDummy {
                String icon = ((ResourceLocation)Validate.notNull((Object)MonkMod.ITEM_MONK_BASE.getRegistryName())).toString();
                int data;
            }
        }
    }

    public static class JSonObjBuilder {
        JsonObject jsonObject = new JsonObject();

        public JsonObject build() {
            return this.jsonObject;
        }

        public JSonObjBuilder add(String property, JsonElement value) {
            this.jsonObject.add(property, value);
            return this;
        }

        public JSonObjBuilder add(String property, JSonObjBuilder value) {
            this.jsonObject.add(property, (JsonElement)value.build());
            return this;
        }

        public JSonObjBuilder add(String property, String value) {
            this.jsonObject.addProperty(property, value);
            return this;
        }

        public JSonObjBuilder add(String property, Number value) {
            this.jsonObject.addProperty(property, value);
            return this;
        }

        public JSonObjBuilder add(String property, Boolean value) {
            this.jsonObject.addProperty(property, value);
            return this;
        }

        public JSonObjBuilder add(String property, Character value) {
            this.jsonObject.addProperty(property, value);
            return this;
        }
    }
}

