/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.monkmod.data;

import com.rwtema.monkmod.MonkMod;
import com.rwtema.monkmod.helper.NBTSerializer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;

public class MonkData
implements INBTSerializable<NBTTagCompound>,
ICapabilityProvider {
    public static final ResourceLocation LOCATION = new ResourceLocation("monk", "monk_level_data");
    @CapabilityInject(value=MonkData.class)
    public static final Capability<MonkData> MONKLEVELDATA = null;
    private static final NBTSerializer<MonkData> serializer = NBTSerializer.createSerializer().addInteger("level", MonkData::getLevel, MonkData::setLevel).addInteger("progress", MonkData::getProgress, MonkData::setProgress);
    public int prevLevel = -112;
    private int progress;
    private int level = -1;

    @CapabilityInject(value=MonkData.class)
    public static void test(Capability<MonkData> cap) {
        MonkMod.logger.debug("Cap Registered");
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public NBTTagCompound serializeNBT() {
        return serializer.serialize(this, new NBTTagCompound());
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        serializer.deserialize(this, nbt);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        assert (MONKLEVELDATA != null);
        return capability == MONKLEVELDATA;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        assert (MONKLEVELDATA != null);
        return (T)(capability == MONKLEVELDATA ? MONKLEVELDATA.cast((Object)this) : null);
    }

    public void increaseProgress(int k) {
        this.progress += k;
    }

    public boolean increase(int k, int threshold) {
        this.progress += k;
        return this.progress >= threshold;
    }
}

