/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.monkmod.advancements.criteria;

import com.rwtema.monkmod.MonkManager;
import com.rwtema.monkmod.abilities.MonkAbility;
import com.rwtema.monkmod.advancements.criteria.MonkRequirementTick;
import com.rwtema.monkmod.data.MonkData;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MonkRequirementEnemyDefeat<T extends EntityLivingBase>
extends MonkRequirementTick {
    private final WeakHashMap<T, WeakHashMap<EntityPlayerMP, Entry>> entryTracker = new WeakHashMap();
    private final Class<T> clazz;

    public MonkRequirementEnemyDefeat(int level, Class<T> clazz) {
        super(level);
        this.clazz = clazz;
    }

    @Override
    protected void doTick(EntityPlayerMP player, MonkData monkData) {
        if (!this.entryTracker.isEmpty() && !MonkAbility.isUnarmored((EntityPlayer)player)) {
            this.disqualifyPlayer(player);
        }
    }

    private void disqualifyPlayer(EntityPlayerMP player) {
        if (this.entryTracker.values().removeIf(m -> {
            Entry remove = (Entry)m.remove(player);
            if (remove != null) {
                remove.disqualified = true;
            }
            return m.isEmpty();
        })) {
            player.func_146105_b((ITextComponent)new TextComponentTranslation("monk.disqualify", new Object[0]), true);
        }
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K || this.entryTracker.isEmpty() || !this.clazz.isInstance(event.getEntity())) {
            return;
        }
        EntityLivingBase entityLiving = event.getEntityLiving();
        WeakHashMap<EntityPlayerMP, Entry> map = this.entryTracker.get(this.clazz.cast(entityLiving));
        if (map == null) {
            return;
        }
        for (Map.Entry<EntityPlayerMP, Entry> playerMPEntryEntry : map.entrySet()) {
            EntityPlayerMP player = playerMPEntryEntry.getKey();
            MonkData monkData = MonkManager.get((EntityPlayer)player);
            if (monkData.getLevel() != this.levelToGrant - 1 || playerMPEntryEntry.getValue().disqualified || !(playerMPEntryEntry.getValue().damage > event.getEntityLiving().func_110138_aP() / 4.0f)) continue;
            this.grantLevel(player);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDamage(LivingDamageEvent event) {
        EntityPlayerMP player;
        MonkData monkData;
        DamageSource source;
        Entity trueSource;
        if (!event.getEntity().field_70170_p.field_72995_K && this.clazz.isInstance(event.getEntity()) && (trueSource = (source = event.getSource()).func_76346_g()) instanceof EntityPlayerMP && (monkData = MonkManager.get((EntityPlayer)(player = (EntityPlayerMP)trueSource))).getLevel() == this.levelToGrant - 1) {
            if (source.func_76352_a()) {
                this.disqualifyPlayer(player);
            } else {
                Entry entry = this.entryTracker.computeIfAbsent(this.clazz.cast(event.getEntity()), t -> new WeakHashMap()).computeIfAbsent(player, p -> new Entry());
                entry.damage += event.getAmount();
            }
        }
    }

    private class Entry {
        boolean disqualified;
        float damage;

        private Entry() {
        }
    }
}

