/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.monkmod.advancements.criteria;

import com.rwtema.monkmod.MonkManager;
import com.rwtema.monkmod.advancements.MonkRequirement;
import com.rwtema.monkmod.data.MonkData;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MonkRequirementBedrockSleep
extends MonkRequirement {
    public MonkRequirementBedrockSleep(int level) {
        super(level);
    }

    @SubscribeEvent
    public void rightClickBedrock(PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player;
        MonkData monkData;
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        if (world.field_73011_w.func_76567_e() && world.func_180494_b(pos) != Biomes.field_76778_j && (monkData = MonkManager.get(player = event.getEntityPlayer())).getLevel() == this.levelToGrant - 1) {
            if (!this.checkPos(world, pos)) {
                return;
            }
            event.setCancellationResult(EnumActionResult.SUCCESS);
            event.setCanceled(true);
            if (world.field_72995_K) {
                return;
            }
            player.func_180469_a(pos.func_177984_a());
        }
    }

    private boolean checkPos(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != Blocks.field_150357_h || !world.func_175623_d(pos.func_177984_a())) {
            return false;
        }
        for (EnumFacing horizontal : EnumFacing.field_176754_o) {
            BlockPos offset = pos.func_177972_a(horizontal);
            if (world.func_180495_p(offset).func_177230_c() != Blocks.field_150357_h || !world.func_175623_d(offset.func_177984_a())) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void awaken(PlayerWakeUpEvent event) {
        MonkData monkData;
        EntityPlayer entityPlayer = event.getEntityPlayer();
        if (entityPlayer instanceof EntityPlayerMP && (monkData = MonkManager.get(entityPlayer)).getLevel() == this.levelToGrant - 1 && this.checkPos(entityPlayer.field_70170_p, entityPlayer.field_71081_bT.func_177977_b())) {
            this.grantLevel((EntityPlayerMP)entityPlayer);
        }
    }

    @SubscribeEvent
    public void continueSleep(SleepingLocationCheckEvent event) {
        EntityPlayer entityPlayer = event.getEntityPlayer();
        MonkData monkData = MonkManager.get(entityPlayer);
        if (monkData.getLevel() == this.levelToGrant - 1 && this.checkPos(entityPlayer.field_70170_p, event.getSleepingLocation().func_177977_b())) {
            event.setResult(Event.Result.ALLOW);
        }
    }
}

