/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.monkmod.advancements.criteria;

import com.rwtema.monkmod.MonkManager;
import com.rwtema.monkmod.advancements.criteria.MonkRequirementTick;
import com.rwtema.monkmod.data.MonkData;
import java.util.Collection;
import java.util.LinkedList;
import java.util.WeakHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MonkRequirementArrow
extends MonkRequirementTick {
    private final WeakHashMap<EntityPlayerMP, Collection<EntityArrow>> arrows = new WeakHashMap();
    private final int numDodges;

    public MonkRequirementArrow(int level, int numDodges) {
        super(level);
        this.numDodges = numDodges;
    }

    @Override
    protected void doTick(EntityPlayerMP player, MonkData monkData) {
        Collection<EntityArrow> entityArrows = this.arrows.get(player);
        if (entityArrows == null) {
            return;
        }
        entityArrows.removeIf(arrow -> {
            Vec3d b;
            if (arrow.field_70122_E || arrow.field_70128_L) {
                return true;
            }
            Entity shootingEntity = arrow.field_70250_c;
            if (shootingEntity == null) {
                return true;
            }
            Vec3d a = new Vec3d(player.field_70165_t - shootingEntity.field_70165_t, player.field_70163_u - shootingEntity.field_70163_u, player.field_70161_v - shootingEntity.field_70161_v).func_72432_b();
            double v = a.func_72430_b(b = new Vec3d(player.field_70165_t - arrow.field_70165_t, player.field_70163_u - arrow.field_70163_u, player.field_70161_v - arrow.field_70161_v).func_72432_b());
            if (v < -0.1) {
                monkData.increaseProgress(1);
                return true;
            }
            return false;
        });
        if (monkData.getProgress() >= this.numDodges) {
            this.arrows.remove(player);
            this.grantLevel(player);
        }
    }

    @SubscribeEvent
    public void onImpact(ProjectileImpactEvent.Arrow event) {
        EntityPlayerMP playerMP;
        MonkData monkData;
        if (event.getArrow().field_70170_p.field_72995_K) {
            return;
        }
        RayTraceResult rayTraceResult = event.getRayTraceResult();
        Entity entityHit = rayTraceResult.field_72308_g;
        if (entityHit instanceof EntityPlayerMP && (monkData = MonkManager.get((EntityPlayer)(playerMP = (EntityPlayerMP)entityHit))).getLevel() == this.levelToGrant - 1) {
            monkData.setProgress(0);
        }
        this.arrows.values().forEach(entityArrows -> entityArrows.remove(event.getArrow()));
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (!entity.field_70170_p.field_72995_K && entity instanceof EntityArrow) {
            EntityPlayerMP playerMP;
            MonkData monkData;
            EntityLivingBase attackTarget;
            EntityArrow arrow = (EntityArrow)entity;
            Entity shootingEntity = arrow.field_70250_c;
            if (shootingEntity instanceof EntitySkeleton && (attackTarget = ((EntitySkeleton)shootingEntity).func_70638_az()) instanceof EntityPlayerMP && (monkData = MonkManager.get((EntityPlayer)(playerMP = (EntityPlayerMP)attackTarget))).getLevel() == this.levelToGrant - 1) {
                this.arrows.computeIfAbsent(playerMP, p -> new LinkedList()).add(arrow);
            }
        }
    }
}

