/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.monkmod.abilities;

import com.rwtema.monkmod.abilities.MonkAbility;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import org.apache.commons.lang3.Validate;

public abstract class MonkAbilityAttribute
extends MonkAbility {
    public static final HashMap<UUID, MonkAbilityAttribute> uuids = new HashMap();
    public final UUID uuid;
    public final IAttribute attribute;
    public final int operation;
    public final double[] levels;

    public MonkAbilityAttribute(String name, IAttribute attribute, double[] levels, int operation) {
        super(name, levels.length);
        this.uuid = this.generate(name);
        this.attribute = attribute;
        this.levels = levels;
        this.operation = operation;
        Validate.isTrue((uuids.put(this.uuid, this) == null ? 1 : 0) != 0);
    }

    @Override
    public void tickServer(EntityPlayerMP player, int level) {
        IAttributeInstance entityAttribute = player.func_110148_a(this.attribute);
        AttributeModifier modifier = entityAttribute.func_111127_a(this.uuid);
        if (this.canApply((EntityPlayer)player)) {
            double amount = this.getAmount(level, (EntityPlayer)player);
            if (modifier == null || modifier.func_111164_d() != amount) {
                if (modifier != null) {
                    entityAttribute.func_188479_b(this.uuid);
                }
                AttributeModifier attributeModifier = new AttributeModifier(this.uuid, this.name, amount, this.operation);
                entityAttribute.func_111121_a(attributeModifier);
            }
        } else if (modifier != null) {
            entityAttribute.func_111124_b(modifier);
        }
        super.tickServer(player, level);
    }

    public UUID generate(String name) {
        return UUID.nameUUIDFromBytes(name.getBytes(Charset.defaultCharset()));
    }

    public double getAmount(int level, EntityPlayer player) {
        return this.levels[level];
    }

    public abstract boolean canApply(EntityPlayer var1);
}

