/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.monkmod.abilities;

import com.google.common.collect.Multimap;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;

public abstract class MonkAbility {
    public static final EntityEquipmentSlot[] HELD_SLOTS = new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND, EntityEquipmentSlot.OFFHAND};
    public static final EntityEquipmentSlot[] ARMOR_SLOTS = new EntityEquipmentSlot[]{EntityEquipmentSlot.FEET, EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS};
    public static Set<String> DAMAGE_MODIFIERS = Stream.of(SharedMonsterAttributes.field_111264_e, SharedMonsterAttributes.field_188790_f).map(IAttribute::func_111108_a).collect(Collectors.toSet());
    public static Set<String> ARMOR_MODIFIERS = Stream.of(SharedMonsterAttributes.field_189429_h, SharedMonsterAttributes.field_188791_g).map(IAttribute::func_111108_a).collect(Collectors.toSet());
    public final String name;
    public final int maxlevel;

    public MonkAbility(String name) {
        this(name, 1);
    }

    public MonkAbility(String name, int maxlevel) {
        this.name = name;
        this.maxlevel = maxlevel;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static boolean isUnarmed(EntityPlayer player) {
        return MonkAbility.checkForContraband(player, HELD_SLOTS, DAMAGE_MODIFIERS);
    }

    private static boolean checkForContraband(EntityPlayer player, EntityEquipmentSlot[] slots, Set<String> illegalModifiers) {
        for (EntityEquipmentSlot slot : slots) {
            Item item;
            Multimap itemAttributeModifiers;
            ItemStack itemStack = player.func_184582_a(slot);
            if (itemStack.func_190926_b() || (itemAttributeModifiers = (item = itemStack.func_77973_b()).getAttributeModifiers(slot, itemStack)).isEmpty()) continue;
            if (!illegalModifiers.stream().anyMatch(arg_0 -> ((Multimap)itemAttributeModifiers).containsKey(arg_0))) continue;
            return false;
        }
        return true;
    }

    public static boolean isUnarmored(EntityPlayer player) {
        return MonkAbility.checkForContraband(player, ARMOR_SLOTS, ARMOR_MODIFIERS);
    }

    public void tickServer(EntityPlayerMP player, int level) {
    }

    public String getUnlocalized(int level) {
        if (this.maxlevel <= 1) {
            return "monk.ability." + this.name;
        }
        return "monk.ability." + this.name + "." + level;
    }
}

