/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.monkmod.abilities;

import com.google.common.collect.ImmutableSet;
import com.rwtema.monkmod.MonkManager;
import com.rwtema.monkmod.abilities.MonkAbility;
import com.rwtema.monkmod.abilities.MonkAbilityAttribute;
import com.rwtema.monkmod.abilities.MonkAbilityBlindness;
import com.rwtema.monkmod.abilities.MonkAbilityBlink;
import com.rwtema.monkmod.abilities.MonkAbilityCreeperKiss;
import com.rwtema.monkmod.abilities.MonkAbilityFly;
import com.rwtema.monkmod.abilities.MonkAbilityHeal;
import com.rwtema.monkmod.abilities.MonkAbilityHunger;
import com.rwtema.monkmod.abilities.MonkAbilityJump;
import com.rwtema.monkmod.abilities.MonkAbilityTameAnimals;
import com.rwtema.monkmod.abilities.MonkAbilityWalkOnWater;
import com.rwtema.monkmod.abilities.MonkAbilityWater;
import com.rwtema.monkmod.abilities.MonkAbilityWitheringStare;
import com.rwtema.monkmod.abilities.MonkCatchArrows;
import com.rwtema.monkmod.abilities.MonkProtection;
import com.rwtema.monkmod.abilities.MonkProtectionFire;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Abilities {
    public static final MonkAbilityHunger HUNGER = new MonkAbilityHunger("hunger");
    public static final MonkAbilityWater WATER_BREATHING = new MonkAbilityWater("water", 2);
    public static final MonkAbilityWitheringStare WITHERING_STARE = new MonkAbilityWitheringStare("withering_stare");
    public static final MonkAbilityWalkOnWater WALK_ON_WATER = new MonkAbilityWalkOnWater("water_walking");
    public static final MonkAbilityAttribute STRENGTH = new MonkAbilityAttribute("punch", SharedMonsterAttributes.field_111264_e, new double[]{1.0, 2.0, 4.0, 8.0, 16.0, 32.0}, 0){

        @Override
        public boolean canApply(EntityPlayer player) {
            return 1.isUnarmed(player);
        }
    };
    public static final MonkAbilityAttribute HEALTH = new MonkAbilityAttribute("health", SharedMonsterAttributes.field_111267_a, new double[]{0.2, 0.4, 0.6, 0.8, 1.0}, 1){

        @Override
        public boolean canApply(EntityPlayer player) {
            return true;
        }
    };
    public static final MonkAbilityAttribute SPEED = new MonkAbilityAttribute("swift", SharedMonsterAttributes.field_111263_d, new double[]{0.1, 0.25, 0.5, 1.0}, 1){

        @Override
        public boolean canApply(EntityPlayer player) {
            return 3.isUnarmored(player);
        }

        @Override
        public double getAmount(int level, EntityPlayer player) {
            double amount = super.getAmount(level, player);
            return player.func_70051_ag() ? amount * 2.0 : amount;
        }

        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public void overrideFOV(FOVUpdateEvent event) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                return;
            }
            int abilityLevel = MonkManager.getAbilityLevel((EntityPlayer)player, this);
            if (abilityLevel == -1) {
                return;
            }
            IAttributeInstance iattributeinstance = player.func_110148_a(SharedMonsterAttributes.field_111263_d);
            double oldMult = this.multiplier(player, iattributeinstance);
            AttributeModifier modifier = iattributeinstance.func_111127_a(this.uuid);
            if (modifier == null) {
                return;
            }
            iattributeinstance.func_111124_b(modifier);
            double newMult = this.multiplier(player, iattributeinstance);
            iattributeinstance.func_111121_a(modifier);
            event.setNewfov((float)((double)event.getFov() / oldMult * newMult));
        }

        @SideOnly(value=Side.CLIENT)
        private double multiplier(EntityPlayerSP player, IAttributeInstance iattributeinstance) {
            return (iattributeinstance.func_111126_e() / (double)player.field_71075_bZ.func_75094_b() + 1.0) / 2.0;
        }
    };
    public static final MonkAbilityBlink BLINK = new MonkAbilityBlink("blink");
    public static final MonkAbilityAttribute ARMOR = new MonkAbilityAttribute("hardskin", SharedMonsterAttributes.field_188791_g, new double[]{2.0, 4.0, 7.0, 11.0, 14.0, 15.0, 20.0}, 0){

        @Override
        public boolean canApply(EntityPlayer player) {
            return 4.isUnarmored(player);
        }
    };
    public static final MonkAbilityAttribute ARMOR_TOUGH = new MonkAbilityAttribute("strong_skin", SharedMonsterAttributes.field_188791_g, new double[]{2.0, 4.0, 8.0}, 0){

        @Override
        public boolean canApply(EntityPlayer player) {
            return 5.isUnarmored(player);
        }
    };
    public static final MonkAbilityTameAnimals PET = new MonkAbilityTameAnimals("tame_animal");
    public static final MonkAbilityCreeperKiss KISS = new MonkAbilityCreeperKiss("creeper_kiss");
    public static final MonkProtection EXPLOSION = new MonkProtection("explosion"){

        @Override
        public float getAbsorbtion(DamageSource source, EntityPlayer player, int abilityLevel) {
            return 0.3f;
        }

        @Override
        public boolean canHandle(EntityPlayer player, DamageSource source) {
            return source.func_94541_c();
        }
    };
    public static final MonkCatchArrows ARROW_CATCH = new MonkCatchArrows("arrow_catch");
    public static final MonkProtection FIRE = new MonkProtectionFire();
    public static final MonkProtection FEATHER_FALLING = new MonkProtection("feather_fall", 2){

        @Override
        public float getAbsorbtion(DamageSource source, EntityPlayer player, int abilityLevel) {
            switch (abilityLevel) {
                case 0: {
                    return 0.2f;
                }
            }
            return 0.0f;
        }

        @Override
        public boolean canHandle(EntityPlayer player, DamageSource source) {
            return source == DamageSource.field_76379_h;
        }
    };
    public static final MonkAbility JUMP = new MonkAbilityJump("jump");
    public static final MonkAbility BLIND = new MonkAbilityBlindness("blindness", 2);
    public static final MonkAbility FLY = new MonkAbilityFly("fly");
    public static final MonkAbility POTION_IMMUNITY = new MonkAbilityHeal("potionImmunity");
    public static final MonkAbility MINING;

    static {
        final float[] speeds = new float[]{2.0f, 4.0f, 7.0f, 12.0f, 32.0f};
        ImmutableSet validBlocks = ImmutableSet.of((Object)"", (Object)"pickaxe", (Object)"shovel", (Object)"axe");
        MINING = new MonkAbility("mine_speed", speeds.length, (Set)validBlocks){
            final /* synthetic */ Set val$validBlocks;
            {
                this.val$validBlocks = set;
                super(name, maxlevel);
            }

            @SubscribeEvent
            public void onMine(PlayerEvent.BreakSpeed event) {
                int abilityLevel = MonkManager.getAbilityLevel(event.getEntityPlayer(), this);
                if (abilityLevel == -1) {
                    return;
                }
                float speedMultiplier = speeds[abilityLevel];
                float oldSpeed = Math.min(event.getOriginalSpeed(), 1.0f);
                event.setNewSpeed(Math.max(event.getNewSpeed(), speedMultiplier * oldSpeed));
            }

            @SubscribeEvent
            public void onHarvest(PlayerEvent.HarvestCheck event) {
                int abilityLevel = MonkManager.getAbilityLevel(event.getEntityPlayer(), this);
                if (abilityLevel == -1) {
                    return;
                }
                IBlockState targetBlock = event.getTargetBlock();
                String harvestTool = targetBlock.func_177230_c().getHarvestTool(targetBlock);
                if (harvestTool != null && (abilityLevel == 0 && "pickaxe".equals(harvestTool) || !this.val$validBlocks.contains(harvestTool))) {
                    return;
                }
                if (targetBlock.func_177230_c().getHarvestLevel(targetBlock) <= abilityLevel) {
                    event.setCanHarvest(true);
                }
            }
        };
    }
}

