/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.monkmod;

import com.rwtema.monkmod.ClientRunnable;
import com.rwtema.monkmod.MonkManager;
import com.rwtema.monkmod.advancements.MonkCriterionTrigger;
import com.rwtema.monkmod.command.CommandMonkLevelManip;
import com.rwtema.monkmod.data.MonkData;
import com.rwtema.monkmod.item.ItemMonkBase;
import com.rwtema.monkmod.levels.MonkLevels;
import com.rwtema.monkmod.network.MonkNetwork;
import gnu.trove.map.hash.TIntObjectHashMap;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;

@Mod(modid="monk", name="Monk", version="1.0", acceptedMinecraftVersions="[1.12.2]")
public class MonkMod {
    public static final String MODID = "monk";
    public static final String NAME = "Monk";
    public static final String VERSION = "1.0";
    public static final MonkCriterionTrigger TRIGGER = (MonkCriterionTrigger)CriteriaTriggers.func_192118_a((ICriterionTrigger)new MonkCriterionTrigger());
    public static final ItemMonkBase ITEM_MONK_BASE = new ItemMonkBase();
    public static final int MAX_LEVEL = 20;
    public static Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        CapabilityManager.INSTANCE.register(MonkData.class, (Capability.IStorage)new Capability.IStorage<MonkData>(){

            @Nullable
            public NBTBase writeNBT(Capability<MonkData> capability, MonkData instance, EnumFacing side) {
                return instance.serializeNBT();
            }

            public void readNBT(Capability<MonkData> capability, MonkData instance, EnumFacing side, NBTBase nbt) {
                instance.deserializeNBT((NBTTagCompound)nbt);
            }
        }, () -> {
            throw new RuntimeException();
        });
        MinecraftForge.EVENT_BUS.register(MonkManager.class);
        MonkLevels.init();
        final ResourceLocation location = new ResourceLocation(MODID, "monk_level");
        ITEM_MONK_BASE.setRegistryName(location);
        ITEM_MONK_BASE.func_77655_b(location.toString());
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)ITEM_MONK_BASE);
        new ClientRunnable(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public void run() {
                TIntObjectHashMap map = new TIntObjectHashMap();
                for (int i = 0; i <= 21; ++i) {
                    ModelResourceLocation modelResourceLocation = new ModelResourceLocation(location.toString() + "_" + i, "inventory");
                    map.put(i, (Object)modelResourceLocation);
                    ModelLoader.setCustomModelResourceLocation((Item)ITEM_MONK_BASE, (int)i, (ModelResourceLocation)modelResourceLocation);
                    ModelBakery.registerItemVariants((Item)ITEM_MONK_BASE, (ResourceLocation[])new ResourceLocation[]{modelResourceLocation});
                }
                ModelLoader.setCustomMeshDefinition((Item)ITEM_MONK_BASE, stack -> map.containsKey(stack.func_77960_j()) ? (ModelResourceLocation)map.get(stack.func_77960_j()) : (ModelResourceLocation)map.get(0));
            }
        }.run();
        MonkNetwork.init();
    }

    @Mod.EventHandler
    public void onServerStart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandMonkLevelManip());
    }
}

