/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.monkmod;

import com.rwtema.monkmod.abilities.MonkAbility;
import com.rwtema.monkmod.abilities.MonkAbilityAttribute;
import com.rwtema.monkmod.data.MonkData;
import com.rwtema.monkmod.levels.MonkLevelManager;
import com.rwtema.monkmod.network.MessageMonkLevelData;
import com.rwtema.monkmod.network.MonkNetwork;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MonkManager {
    @SubscribeEvent
    public static void registerCap(AttachCapabilitiesEvent<Entity> playerAttachCapabilitiesEvent) {
        if (playerAttachCapabilitiesEvent.getObject() instanceof EntityPlayer) {
            playerAttachCapabilitiesEvent.addCapability(MonkData.LOCATION, (ICapabilityProvider)new MonkData());
        }
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        MonkData oldData = MonkManager.get(event.getOriginal());
        MonkData newData = MonkManager.get(event.getEntityPlayer());
        newData.deserializeNBT(oldData.serializeNBT());
    }

    @SubscribeEvent
    public static void onWatch(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        MonkManager.updatePlayer(player, MonkManager.get((EntityPlayer)player));
    }

    private static void updatePlayer(EntityPlayerMP player, MonkData monkData) {
        MonkNetwork.net.sendTo((IMessage)new MessageMonkLevelData(monkData), player);
    }

    @SubscribeEvent
    public static void tick(TickEvent.PlayerTickEvent event) {
        if (event.player.field_70170_p.field_72995_K || event.phase == TickEvent.Phase.START) {
            return;
        }
        MonkData monkData = MonkManager.get(event.player);
        EntityPlayerMP playerMP = (EntityPlayerMP)event.player;
        if (monkData.getLevel() != monkData.prevLevel) {
            MonkManager.updatePlayer(playerMP, monkData);
            monkData.prevLevel = monkData.getLevel();
        }
        Map<MonkAbility, Integer> abilities = MonkLevelManager.getAbilities(monkData.getLevel());
        abilities.forEach((ability, level) -> ability.tickServer(playerMP, (int)level));
        AbstractAttributeMap attributeMap = event.player.func_110140_aT();
        for (IAttributeInstance attributeInstance : attributeMap.func_111146_a()) {
            MonkAbilityAttribute.uuids.forEach((uuid, monkAbilityAttribute) -> {
                if (attributeInstance.func_111127_a(uuid) != null && !abilities.containsKey(monkAbilityAttribute)) {
                    attributeInstance.func_188479_b(uuid);
                }
            });
        }
    }

    public static MonkData get(EntityPlayer player) {
        return (MonkData)player.getCapability(MonkData.MONKLEVELDATA, null);
    }

    public static int getAbilityLevel(EntityPlayer player, MonkAbility ability) {
        return MonkLevelManager.getAbilities(MonkManager.get(player).getLevel()).getOrDefault(ability, -1);
    }

    public static boolean hasAbility(EntityPlayer player, MonkAbility ability) {
        return MonkManager.getAbilityLevel(player, ability) >= 0;
    }
}

