/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.fracture.common.util;

import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;

public class Vector3 {
    private static final Random RAND = new Random();
    protected double x;
    protected double y;
    protected double z;

    public Vector3() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public Vector3(Vector3 copy) {
        this.x = copy.x;
        this.y = copy.y;
        this.z = copy.z;
    }

    public Vector3(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3(BlockPos pos) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public Vector3(TileEntity te) {
        this(te.func_174877_v().func_177958_n(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p());
    }

    public Vector3(Vec3d vec) {
        this(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public static Vector3 atEntityCorner(Entity entity) {
        return new Vector3(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public static Vector3 atEntityCenter(Entity entity) {
        Vector3 offset = Vector3.atEntityCorner(entity);
        return offset.add(entity.field_70130_N / 2.0f, entity.field_70131_O / 2.0f, entity.field_70130_N / 2.0f);
    }

    public Vector3 add(Vec3i vec) {
        this.x += (double)vec.func_177958_n();
        this.y += (double)vec.func_177956_o();
        this.z += (double)vec.func_177952_p();
        return this;
    }

    public Vector3 add(Vector3 vec) {
        this.x += vec.x;
        this.y += vec.y;
        this.z += vec.z;
        return this;
    }

    public Vector3 add(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public Vector3 addX(double x) {
        this.x += x;
        return this;
    }

    public Vector3 addY(double y) {
        this.y += y;
        return this;
    }

    public Vector3 addZ(double z) {
        this.z += z;
        return this;
    }

    public Vector3 subtract(double vX, double vY, double vZ) {
        this.x -= vX;
        this.y -= vY;
        this.z -= vZ;
        return this;
    }

    public Vector3 subtract(Entity e) {
        this.x -= e.field_70165_t;
        this.y -= e.field_70163_u;
        this.z -= e.field_70161_v;
        return this;
    }

    public Vector3 subtract(Vec3i vec) {
        this.x -= (double)vec.func_177958_n();
        this.y -= (double)vec.func_177956_o();
        this.z -= (double)vec.func_177952_p();
        return this;
    }

    public Vector3 subtract(Vector3 vec) {
        this.x -= vec.x;
        this.y -= vec.y;
        this.z -= vec.z;
        return this;
    }

    public Vector3 multiply(Vector3 vec) {
        this.x *= vec.x;
        this.y *= vec.y;
        this.z *= vec.z;
        return this;
    }

    public Vector3 divide(Vector3 vec) {
        this.x /= vec.x;
        this.y /= vec.y;
        this.z /= vec.z;
        return this;
    }

    public Vector3 divide(double divisor) {
        this.x /= divisor;
        this.y /= divisor;
        this.z /= divisor;
        return this;
    }

    public Vector3 negate() {
        this.x *= -1.0;
        this.y *= -1.0;
        this.z *= -1.0;
        return this;
    }

    public Vector3 copy(Vector3 vec) {
        this.x = vec.x;
        this.y = vec.y;
        this.z = vec.z;
        return this;
    }

    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    public double lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double distance(Vector3 o) {
        return Math.sqrt(this.distanceSquared(o));
    }

    public double distanceSquared(Vector3 o) {
        double difX = this.x - o.x;
        double difY = this.y - o.y;
        double difZ = this.z - o.z;
        return difX * difX + difY * difY + difZ * difZ;
    }

    public double distance(Vec3i o) {
        return Math.sqrt(this.distanceSquared(o));
    }

    public double distanceSquared(Vec3i o) {
        double difX = this.x - (double)o.func_177958_n();
        double difY = this.y - (double)o.func_177956_o();
        double difZ = this.z - (double)o.func_177952_p();
        return difX * difX + difY * difY + difZ * difZ;
    }

    public double distance(Vec3d o) {
        return Math.sqrt(this.distanceSquared(o));
    }

    public double distanceSquared(Vec3d o) {
        double difX = this.x - o.field_72450_a;
        double difY = this.y - o.field_72448_b;
        double difZ = this.z - o.field_72449_c;
        return difX * difX + difY * difY + difZ * difZ;
    }

    public float angle(Vector3 other) {
        double dot = this.dot(other) / (this.length() * other.length());
        return (float)Math.acos(dot);
    }

    public Vector3 midpoint(Vector3 other) {
        this.x = (this.x + other.x) / 2.0;
        this.y = (this.y + other.y) / 2.0;
        this.z = (this.z + other.z) / 2.0;
        return this;
    }

    public Vector3 getMidpoint(Vector3 other) {
        double x = (this.x + other.x) / 2.0;
        double y = (this.y + other.y) / 2.0;
        double z = (this.z + other.z) / 2.0;
        return new Vector3(x, y, z);
    }

    public Vector3 multiply(int m) {
        this.x *= (double)m;
        this.y *= (double)m;
        this.z *= (double)m;
        return this;
    }

    public Vector3 multiply(double m) {
        this.x *= m;
        this.y *= m;
        this.z *= m;
        return this;
    }

    public Vector3 multiply(float m) {
        this.x *= (double)m;
        this.y *= (double)m;
        this.z *= (double)m;
        return this;
    }

    public double dot(Vector3 other) {
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public Vector3 crossProduct(Vector3 o) {
        double newX = this.y * o.z - o.y * this.z;
        double newY = this.z * o.x - o.z * this.x;
        double newZ = this.x * o.y - o.x * this.y;
        this.x = newX;
        this.y = newY;
        this.z = newZ;
        return this;
    }

    public Vector3 perpendicular() {
        if (this.z == 0.0) {
            return this.zCrossProduct();
        }
        return this.xCrossProduct();
    }

    public Vector3 xCrossProduct() {
        double d = this.z;
        double d1 = -this.y;
        this.x = 0.0;
        this.y = d;
        this.z = d1;
        return this;
    }

    public Vector3 zCrossProduct() {
        double d = this.y;
        double d1 = -this.x;
        this.x = d;
        this.y = d1;
        this.z = 0.0;
        return this;
    }

    public Vector3 yCrossProduct() {
        double d = -this.z;
        double d1 = this.x;
        this.x = d;
        this.y = 0.0;
        this.z = d1;
        return this;
    }

    public Vector3 rotate(double angle, Vector3 axis) {
        Quat.buildQuatFrom3DVector(axis.clone().normalize(), angle).rotateWithMagnitude(this);
        return this;
    }

    public Vector3 normalize() {
        double length = this.length();
        this.x /= length;
        this.y /= length;
        this.z /= length;
        return this;
    }

    public Vector3 fastLowAccNormalize() {
        double lengthSq = this.lengthSquared();
        lengthSq = Vector3.fastInvSqrt(lengthSq);
        this.x *= lengthSq;
        this.y *= lengthSq;
        this.z *= lengthSq;
        return this;
    }

    public static double fastInvSqrt(double x) {
        double xhalf = 0.5 * x;
        long i = Double.doubleToLongBits(x);
        i = 6910470738111508698L - (i >> 1);
        x = Double.longBitsToDouble(i);
        for (int it = 0; it < 4; ++it) {
            x *= 1.5 - xhalf * x * x;
        }
        return x;
    }

    public Vector3 zero() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        return this;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
    }

    public static Vector3 fromBytes(ByteBuf buf) {
        return new Vector3(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public static Vector3 random() {
        return new Vector3(RAND.nextDouble() * (double)(RAND.nextBoolean() ? 1 : -1), RAND.nextDouble() * (double)(RAND.nextBoolean() ? 1 : -1), RAND.nextDouble() * (double)(RAND.nextBoolean() ? 1 : -1));
    }

    public static Vector3 random(Random rand) {
        return new Vector3(rand.nextDouble() * (double)(rand.nextBoolean() ? 1 : -1), rand.nextDouble() * (double)(rand.nextBoolean() ? 1 : -1), rand.nextDouble() * (double)(rand.nextBoolean() ? 1 : -1));
    }

    public static Vector3 positiveYRandom() {
        Vector3 rand = Vector3.random();
        return rand.setY(Math.abs(rand.getY()));
    }

    public static Vector3 positiveYRandom(Random r) {
        Vector3 rand = Vector3.random(r);
        return rand.setY(Math.abs(rand.getY()));
    }

    public boolean isInAABB(Vector3 min, Vector3 max) {
        return this.x >= min.x && this.x <= max.x && this.y >= min.y && this.y <= max.y && this.z >= min.z && this.z <= max.z;
    }

    public boolean isInSphere(Vector3 origin, double radius) {
        double difX = origin.x - this.x;
        double difY = origin.y - this.y;
        double difZ = origin.z - this.z;
        return difX * difX + difY * difY + difZ * difZ <= radius * radius;
    }

    public Vec3d toVec3d() {
        return new Vec3d(this.x, this.y, this.z);
    }

    public BlockPos toBlockPos() {
        return new BlockPos(MathHelper.func_76128_c((double)this.x), MathHelper.func_76128_c((double)this.y), MathHelper.func_76128_c((double)this.z));
    }

    public Vector3 vectorFromHereTo(Vector3 target) {
        return new Vector3(target.x - this.x, target.y - this.y, target.z - this.z);
    }

    public Vector3 vectorFromHereTo(double tX, double tY, double tZ) {
        return new Vector3(tX - this.x, tY - this.y, tZ - this.z);
    }

    public Vector3 copyToPolar() {
        double length = this.length();
        double theta = Math.acos(this.y / length);
        double phi = Math.atan2(this.x, this.z);
        theta = Math.toDegrees(theta);
        phi = 180.0 + Math.toDegrees(phi);
        return new Vector3(length, theta, phi);
    }

    public Vector3 copyInterpolateWith(Vector3 next, float partial) {
        return new Vector3(this.x == next.x ? this.x : this.x + (next.x - this.x) * (double)partial, this.y == next.y ? this.y : this.y + (next.y - this.y) * (double)partial, this.z == next.z ? this.z : this.z + (next.z - this.z) * (double)partial);
    }

    public double getX() {
        return this.x;
    }

    public int getBlockX() {
        return (int)Math.floor(this.x);
    }

    public double getY() {
        return this.y;
    }

    public int getBlockY() {
        return (int)Math.floor(this.y);
    }

    public double getZ() {
        return this.z;
    }

    public int getBlockZ() {
        return (int)Math.floor(this.z);
    }

    public Vector3 setX(int x) {
        this.x = x;
        return this;
    }

    public Vector3 setX(double x) {
        this.x = x;
        return this;
    }

    public Vector3 setX(float x) {
        this.x = x;
        return this;
    }

    public Vector3 setY(int y) {
        this.y = y;
        return this;
    }

    public Vector3 setY(double y) {
        this.y = y;
        return this;
    }

    public Vector3 setY(float y) {
        this.y = y;
        return this;
    }

    public Vector3 setZ(int z) {
        this.z = z;
        return this;
    }

    public Vector3 setZ(double z) {
        this.z = z;
        return this;
    }

    public Vector3 setZ(float z) {
        this.z = z;
        return this;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Vector3)) {
            return false;
        }
        Vector3 other = (Vector3)obj;
        return Math.abs(this.x - other.x) < 1.0E-4 && Math.abs(this.y - other.y) < 1.0E-4 && Math.abs(this.z - other.z) < 1.0E-4 && this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + (int)(Double.doubleToLongBits(this.x) ^ Double.doubleToLongBits(this.x) >>> 32);
        hash = 79 * hash + (int)(Double.doubleToLongBits(this.y) ^ Double.doubleToLongBits(this.y) >>> 32);
        hash = 79 * hash + (int)(Double.doubleToLongBits(this.z) ^ Double.doubleToLongBits(this.z) >>> 32);
        return hash;
    }

    public Vector3 clone() {
        return new Vector3(this.x, this.y, this.z);
    }

    public String toString() {
        return this.x + "," + this.y + "," + this.z;
    }

    public static class RotAxis {
        public static final Vector3 X_AXIS = new Vector3(1, 0, 0);
        public static final Vector3 Y_AXIS = new Vector3(0, 1, 0);
        public static final Vector3 Z_AXIS = new Vector3(0, 0, 1);
    }

    public static class Quat {
        public double i;
        public double j;
        public double k;
        public double s;

        public Quat() {
            this(1.0);
        }

        public Quat(double zeroMag) {
            this.s = zeroMag;
            this.i = 0.0;
            this.j = 0.0;
            this.k = 0.0;
        }

        public Quat(Quat quat) {
            this.i = quat.i;
            this.j = quat.j;
            this.k = quat.k;
            this.s = quat.s;
        }

        public Quat(double w, double i, double j, double k) {
            this.i = i;
            this.j = j;
            this.k = k;
            this.s = w;
        }

        public void set(Quat quat) {
            this.i = quat.i;
            this.j = quat.j;
            this.k = quat.k;
            this.s = quat.s;
        }

        public static Quat buildQuatWithAngle(double ax, double ay, double az, double angle) {
            double d4 = Math.sin(angle *= 0.5);
            return new Quat(Math.cos(angle), ax * d4, ay * d4, az * d4);
        }

        public void leftMultiply(Quat quat) {
            double d = this.s * quat.s - this.i * quat.i - this.j * quat.j - this.k * quat.k;
            double d1 = this.s * quat.i + this.i * quat.s - this.j * quat.k + this.k * quat.j;
            double d2 = this.s * quat.j + this.i * quat.k + this.j * quat.s - this.k * quat.i;
            double d3 = this.s * quat.k - this.i * quat.j + this.j * quat.i + this.k * quat.s;
            this.s = d;
            this.i = d1;
            this.j = d2;
            this.k = d3;
        }

        public void rightMultiply(Quat quat) {
            double d = this.s * quat.s - this.i * quat.i - this.j * quat.j - this.k * quat.k;
            double d1 = this.s * quat.i + this.i * quat.s + this.j * quat.k - this.k * quat.j;
            double d2 = this.s * quat.j - this.i * quat.k + this.j * quat.s + this.k * quat.i;
            double d3 = this.s * quat.k + this.i * quat.j - this.j * quat.i + this.k * quat.s;
            this.s = d;
            this.i = d1;
            this.j = d2;
            this.k = d3;
        }

        public double mag() {
            return Math.sqrt(this.i * this.i + this.j * this.j + this.k * this.k + this.s * this.s);
        }

        public void normalize() {
            double d = this.mag();
            if (d == 0.0) {
                return;
            }
            d = 1.0 / d;
            this.i *= d;
            this.j *= d;
            this.k *= d;
            this.s *= d;
        }

        public void rotateWithMagnitude(Vector3 vec) {
            double d = -this.i * vec.x - this.j * vec.y - this.k * vec.z;
            double d1 = this.s * vec.x + this.j * vec.z - this.k * vec.y;
            double d2 = this.s * vec.y - this.i * vec.z + this.k * vec.x;
            double d3 = this.s * vec.z + this.i * vec.y - this.j * vec.x;
            vec.x = d1 * this.s - d * this.i - d2 * this.k + d3 * this.j;
            vec.y = d2 * this.s - d * this.j + d1 * this.k - d3 * this.i;
            vec.z = d3 * this.s - d * this.k - d1 * this.j + d2 * this.i;
        }

        public String toString() {
            return String.format("Quaternion: { s=%f, i=%f, j=%f, k=%f }", this.s, this.i, this.j, this.k);
        }

        public static Quat buildQuatFrom3DVector(Vector3 axis, double angle) {
            return Quat.buildQuatWithAngle(axis.x, axis.y, axis.z, angle);
        }
    }
}

