/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.fracture.common.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;

public class ByteBufUtils {
    public static void writeString(PacketBuffer buf, String toWrite) {
        byte[] str = toWrite.getBytes();
        buf.writeInt(str.length);
        buf.writeBytes(str);
    }

    public static void writeString(ByteBuf buf, String toWrite) {
        byte[] str = toWrite.getBytes();
        buf.writeInt(str.length);
        buf.writeBytes(str);
    }

    public static String readString(PacketBuffer buf) {
        int length = buf.readInt();
        byte[] strBytes = new byte[length];
        buf.readBytes(strBytes, 0, length);
        return new String(strBytes);
    }

    public static String readString(ByteBuf buf) {
        int length = buf.readInt();
        byte[] strBytes = new byte[length];
        buf.readBytes(strBytes, 0, length);
        return new String(strBytes);
    }

    public static void writeNBTTag(ByteBuf byteBuf, @Nonnull NBTTagCompound tag) {
        try (DataOutputStream dos = new DataOutputStream((OutputStream)new ByteBufOutputStream(byteBuf));){
            CompressedStreamTools.func_74800_a((NBTTagCompound)tag, (DataOutput)dos);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    public static NBTTagCompound readNBTTag(ByteBuf byteBuf) {
        try (DataInputStream dis = new DataInputStream((InputStream)new ByteBufInputStream(byteBuf));){
            NBTTagCompound nBTTagCompound = CompressedStreamTools.func_74794_a((DataInputStream)dis);
            return nBTTagCompound;
        }
        catch (Exception exception) {
            throw new IllegalStateException("Could not load NBT Tag from incoming byte buffer!");
        }
    }
}

