/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.fracture.common.tile;

import hellfirepvp.fracture.client.effect.EffectHandler;
import hellfirepvp.fracture.client.effect.EntityFX;
import hellfirepvp.fracture.client.effect.fx.EffectLightning;
import hellfirepvp.fracture.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.fracture.client.effect.fx.EntityFXFloatingCube;
import hellfirepvp.fracture.client.texture.AssetLibrary;
import hellfirepvp.fracture.client.texture.AssetLoader;
import hellfirepvp.fracture.common.block.BlockFissureDeviceBase;
import hellfirepvp.fracture.common.block.BlockFissureDevicePillar;
import hellfirepvp.fracture.common.fissure.ClientFissureWorldHandler;
import hellfirepvp.fracture.common.fissure.FissureData;
import hellfirepvp.fracture.common.fissure.FissureDataController;
import hellfirepvp.fracture.common.fissure.swap.FissureSwapHelper;
import hellfirepvp.fracture.common.tile.base.TileEntitySynchronized;
import hellfirepvp.fracture.common.util.Vector3;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileFissureDevice
extends TileEntitySynchronized
implements ITickable {
    private Object headFloatingCube1 = null;
    private Object headFloatingCube2 = null;
    private Object headFloatingCube3 = null;
    private Object outerFloatingCube1 = null;
    private Object outerFloatingCube2 = null;
    private int ticksExisted = 0;
    private float percActive = 0.0f;
    private float percDrawFissure = 0.0f;
    private boolean active = false;
    private EntityPlayer activatedPlayer = null;
    private boolean inSwap = false;
    private float swapPerc = 0.0f;

    public void func_73660_a() {
        ++this.ticksExisted;
        FissureData thisData = FissureDataController.getFissureData(this.field_145850_b.field_73011_w.getDimension(), this.func_174877_v());
        if (!this.field_145850_b.field_72995_K) {
            if (this.ticksExisted % 20 == 0 && this.getStructureDepth() > 0) {
                FissureDataController.updateFissureServer(this);
            }
            if (this.activatedPlayer != null) {
                if (this.activatedPlayer.func_174831_c(this.func_174877_v()) >= 56.25 || this.activatedPlayer.field_70128_L) {
                    this.active = false;
                    this.activatedPlayer = null;
                    this.inSwap = false;
                    this.swapPerc = 0.0f;
                    this.markForUpdate();
                }
            } else if (this.inSwap || this.active || this.swapPerc > 0.0f) {
                this.active = false;
                this.activatedPlayer = null;
                this.inSwap = false;
                this.swapPerc = 0.0f;
                this.markForUpdate();
            }
            this.markForUpdate();
            if (thisData != null) {
                if (!thisData.hasOtherLink()) {
                    Tuple<Integer, BlockPos> linkPair = FissureDataController.getRandomFissureExcept(this);
                    if (linkPair != null) {
                        this.markForUpdate();
                    }
                } else {
                    FissureData otherData = FissureDataController.getFissureData(thisData.getOtherLinkDim(), thisData.getOtherLinkPos());
                    if (otherData != null && otherData.hasOtherLink() && otherData.getOtherLinkDim() == this.field_145850_b.field_73011_w.getDimension() && otherData.getOtherLinkPos().equals((Object)this.func_174877_v()) && this.activatedPlayer != null && this.inSwap) {
                        FissureSwapHelper.prepareSwap(this);
                        this.swapPerc = Math.min(1.0f, this.swapPerc + 0.01f);
                        if (this.swapPerc >= 1.0f && FissureSwapHelper.doSwap(this)) {
                            this.activatedPlayer = null;
                            this.inSwap = false;
                            this.active = false;
                            this.swapPerc = 0.0f;
                        }
                        this.markForUpdate();
                    }
                }
            }
        } else if (thisData != null) {
            float accel = 0.025f;
            if (this.active && this.getStructureDepth() > 0) {
                this.percActive = Math.min(1.0f, this.percActive + accel);
                if (this.percActive >= 1.0f) {
                    float accelDraw = 0.01f;
                    this.percDrawFissure = Math.min(1.0f, this.percDrawFissure + accelDraw);
                }
            } else {
                this.percActive = Math.max(0.0f, this.percActive - accel);
                this.percDrawFissure = 0.0f;
            }
            if (this.active && this.getStructureDepth() > 0 && thisData.hasOtherLink()) {
                FissureData otherLink = FissureDataController.getFissureData(thisData.getOtherLinkDim(), thisData.getOtherLinkPos());
                if (otherLink != null && this.percDrawFissure >= 1.0f) {
                    ClientFissureWorldHandler.activate(this);
                }
            } else {
                ClientFissureWorldHandler.deactivate(this);
                this.percDrawFissure = 0.0f;
            }
            this.playEffects(thisData);
        }
    }

    public void tryStartSwap(EntityPlayer player) {
        if (this.activatedPlayer == null || !this.active || this.inSwap) {
            return;
        }
        if (player.func_145782_y() == this.activatedPlayer.func_145782_y()) {
            this.inSwap = true;
            this.swapPerc = 0.0f;
        }
    }

    public void markActive(EntityPlayer player) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.activatedPlayer = player;
        this.active = true;
        this.markForUpdate();
    }

    public void deactivateServer() {
        FissureDataController.removeFissureServer(this.field_145850_b, this.field_174879_c);
    }

    @SideOnly(value=Side.CLIENT)
    public void deactivateClient() {
        ClientFissureWorldHandler.deactivate(this);
    }

    private int getStructureDepth() {
        IBlockState state;
        Block block;
        BlockPos check = this.field_174879_c;
        int depth = 0;
        do {
            check = check.func_177977_b();
            if (++depth <= 3) continue;
            return -1;
        } while ((block = (state = this.field_145850_b.func_180495_p(check)).func_177230_c()) instanceof BlockFissureDevicePillar);
        if (block instanceof BlockFissureDeviceBase) {
            return depth;
        }
        return -1;
    }

    public Map<BlockPos, IBlockState> getOffsetRangeData(@Nullable Map<BlockPos, IBlockState> existingData) {
        int range = Math.max(0, this.getStructureDepth()) * 4;
        HashMap<BlockPos, IBlockState> data = new HashMap<BlockPos, IBlockState>();
        for (int xx = -range; xx <= range; ++xx) {
            for (int zz = -range; zz <= range; ++zz) {
                BlockPos offsetXZ = this.func_174877_v().func_177982_a(xx, 0, zz);
                if (this.field_145850_b.func_175667_e(offsetXZ) || existingData == null) {
                    for (int yy = -range; yy <= range; ++yy) {
                        BlockPos offset = new BlockPos(xx, yy, zz);
                        BlockPos real = this.func_174877_v().func_177971_a((Vec3i)offset);
                        IBlockState state = this.field_145850_b.func_180495_p(real);
                        if (!(state.func_185887_b(this.field_145850_b, real) >= 0.0f) || this.field_145850_b.func_175625_s(real) != null || state.func_177230_c() instanceof BlockAir) continue;
                        data.put(offset, state);
                    }
                    continue;
                }
                for (BlockPos key : existingData.keySet()) {
                    if (key.func_177958_n() != xx || key.func_177952_p() != zz) continue;
                    data.put(key, existingData.get(key));
                }
            }
        }
        return data;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean clientReadyForSwap() {
        return this.active && this.percDrawFissure >= 1.0f;
    }

    @SideOnly(value=Side.CLIENT)
    private void playEffects(FissureData ownData) {
        int depth = this.getStructureDepth();
        if (depth > 0) {
            EntityFXFacingParticle p;
            Vector3 dir;
            Vector3 particlePos;
            FissureData otherData;
            if (this.headFloatingCube1 == null || ((EntityFXFloatingCube)this.headFloatingCube1).isRemoved()) {
                this.headFloatingCube1 = this.setupCube(0.35f, 0.3f);
            }
            if (this.headFloatingCube2 == null || ((EntityFXFloatingCube)this.headFloatingCube2).isRemoved()) {
                this.headFloatingCube2 = this.setupCube(0.3f, 0.2f);
            }
            if (this.headFloatingCube3 == null || ((EntityFXFloatingCube)this.headFloatingCube3).isRemoved()) {
                this.headFloatingCube3 = this.setupCube(0.25f, 0.04f);
            }
            this.handleAnimations(this.headFloatingCube1);
            this.handleAnimations(this.headFloatingCube2);
            this.handleAnimations(this.headFloatingCube3);
            if (this.percActive >= 1.0f && rand.nextFloat() >= 0.8f) {
                EffectLightning lightning = EffectHandler.getInstance().lightning(new Vector3(0.4 + (double)rand.nextFloat() * 0.2, 0.1 - (double)depth, 0.4 + (double)rand.nextFloat() * 0.2).add((Vec3i)this.func_174877_v()), new Vector3(0.4 + (double)rand.nextFloat() * 0.2, 0.4, 0.4 + (double)rand.nextFloat() * 0.2).add((Vec3i)this.func_174877_v()));
                lightning.setOverlayColor(new Color(3007488));
            }
            if (this.percActive > 0.0f) {
                for (int i = 0; i < depth * 6; ++i) {
                    if (!(rand.nextFloat() <= this.percActive)) continue;
                    EntityFXFacingParticle p2 = new EntityFXFacingParticle(30);
                    p2.setAlphaFunction(EntityFX.AlphaFunction.FADE_OUT);
                    p2.setColor(new Color(3007488));
                    p2.setPosition(new Vector3(this.func_174877_v()).add(0.4 + (double)rand.nextFloat() * 0.2, 0.4, 0.4 + (double)rand.nextFloat() * 0.2).addY((double)(-rand.nextFloat()) * (0.3 + (double)depth)));
                    p2.setScale(0.05f + rand.nextFloat() * 0.05f);
                    p2.setAlphaMultiplier(0.75f);
                    p2.setMotion(Vector3.random().multiply(0.006f));
                    EffectHandler.getInstance().registerFX(p2);
                }
            }
            FissureData fissureData = otherData = ownData.hasOtherLink() ? FissureDataController.getFissureData(ownData.getOtherLinkDim(), ownData.getOtherLinkPos()) : null;
            if (this.swapPerc > 0.0f) {
                int i;
                for (i = 0; i < 40; ++i) {
                    if (!(rand.nextFloat() < this.swapPerc)) continue;
                    Vector3 offset = Vector3.random().multiply(2.5);
                    if (rand.nextBoolean()) {
                        offset = Vector3.random();
                    }
                    particlePos = new Vector3(this.func_174877_v()).add(0.5, 0.5, 0.5).add(offset).addY(1.3);
                    dir = particlePos.clone().subtract((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.3, (double)this.field_174879_c.func_177952_p() + 0.5).normalize().divide(-20.0);
                    p = new EntityFXFacingParticle(30);
                    p.setAlphaFunction(EntityFX.AlphaFunction.PYRAMID);
                    p.setColor(new Color(3007488));
                    p.setPosition(particlePos);
                    p.setScale(0.03f + rand.nextFloat() * 0.03f);
                    p.setAlphaMultiplier(0.85f);
                    p.setMotion(dir);
                    EffectHandler.getInstance().registerFX(p);
                }
                for (i = 0; i < 2; ++i) {
                    if (!(rand.nextFloat() < this.swapPerc) || otherData == null) continue;
                    BlockPos vecSub = otherData.getMax().func_177973_b((Vec3i)otherData.getMin());
                    Vector3 randFrom = new Vector3(otherData.getMin());
                    randFrom.addX((float)vecSub.func_177958_n() * rand.nextFloat());
                    randFrom.addY((float)vecSub.func_177956_o() * rand.nextFloat());
                    randFrom.addZ((float)vecSub.func_177952_p() * rand.nextFloat());
                    randFrom.add((Vec3i)this.func_174877_v());
                    Vector3 randTo = new Vector3(otherData.getMin());
                    randTo.addX((float)vecSub.func_177958_n() * rand.nextFloat());
                    randTo.addY((float)vecSub.func_177956_o() * rand.nextFloat());
                    randTo.addZ((float)vecSub.func_177952_p() * rand.nextFloat());
                    randTo.add((Vec3i)this.func_174877_v());
                    Vector3 dst = randTo.clone().subtract(randFrom);
                    if (dst.length() > 10.0) {
                        dst.normalize().multiply(10);
                    }
                    EffectLightning eff = EffectHandler.getInstance().lightning(randFrom, randFrom.clone().add(dst));
                    eff.setOverlayColor(new Color(3007488));
                }
            }
            this.playOuterCube(otherData);
            if (this.percDrawFissure > 0.0f && otherData != null) {
                if (this.percDrawFissure < 1.0f) {
                    float chance = 1.0f - Math.abs((this.percDrawFissure - 0.5f) * 1.6f);
                    for (int i = 0; i < 19; ++i) {
                        if (!(rand.nextFloat() < chance)) continue;
                        particlePos = new Vector3(this.func_174877_v()).add(0.5, 0.5, 0.5).add(Vector3.random().multiply(2.5)).addY(1.3);
                        dir = particlePos.clone().subtract((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.3, (double)this.field_174879_c.func_177952_p() + 0.5).normalize().divide(-20.0);
                        p = new EntityFXFacingParticle(30);
                        p.setAlphaFunction(EntityFX.AlphaFunction.PYRAMID);
                        p.setColor(new Color(3007488));
                        p.setPosition(particlePos);
                        p.setScale(0.03f + rand.nextFloat() * 0.03f);
                        p.setAlphaMultiplier(0.85f);
                        p.setMotion(dir);
                        EffectHandler.getInstance().registerFX(p);
                    }
                } else {
                    BlockPos vecSub = otherData.getMax().func_177973_b((Vec3i)otherData.getMin());
                    Vector3 randPos = new Vector3(otherData.getMin());
                    randPos.addX((float)vecSub.func_177958_n() * rand.nextFloat());
                    randPos.addY((float)vecSub.func_177956_o() * rand.nextFloat());
                    randPos.addZ((float)vecSub.func_177952_p() * rand.nextFloat());
                    randPos.add((Vec3i)this.func_174877_v());
                    EntityFXFacingParticle p3 = new EntityFXFacingParticle(60);
                    p3.setAlphaFunction(EntityFX.AlphaFunction.PYRAMID);
                    p3.setColor(new Color(3007488));
                    p3.setPosition(randPos);
                    p3.setScale(0.02f + rand.nextFloat() * 0.03f);
                    p3.setAlphaMultiplier(0.75f);
                    p3.setMotion(Vector3.random().multiply(0.01f));
                    EffectHandler.getInstance().registerFX(p3);
                    for (int i = 0; i < 4; ++i) {
                        p3 = new EntityFXFacingParticle(40);
                        p3.setAlphaFunction(EntityFX.AlphaFunction.FADE_OUT);
                        p3.setColor(new Color(3007488));
                        p3.setPosition(new Vector3(this.func_174877_v()).add(0.5, 1.3, 0.5));
                        p3.setScale(0.015f + rand.nextFloat() * 0.02f);
                        p3.setAlphaMultiplier(0.75f);
                        p3.setMotion(Vector3.random().multiply(0.015f));
                        EffectHandler.getInstance().registerFX(p3);
                    }
                    if (rand.nextInt(6) == 0) {
                        Vector3 randFrom = new Vector3(otherData.getMin());
                        randFrom.addX((float)vecSub.func_177958_n() * rand.nextFloat());
                        randFrom.addY((float)vecSub.func_177956_o() * rand.nextFloat());
                        randFrom.addZ((float)vecSub.func_177952_p() * rand.nextFloat());
                        randFrom.add((Vec3i)this.func_174877_v());
                        Vector3 randTo = new Vector3(otherData.getMin());
                        randTo.addX((float)vecSub.func_177958_n() * rand.nextFloat());
                        randTo.addY((float)vecSub.func_177956_o() * rand.nextFloat());
                        randTo.addZ((float)vecSub.func_177952_p() * rand.nextFloat());
                        randTo.add((Vec3i)this.func_174877_v());
                        Vector3 dst = randTo.clone().subtract(randFrom);
                        if (dst.length() > 6.0) {
                            dst.normalize().multiply(6);
                        }
                        EffectLightning eff = EffectHandler.getInstance().lightning(randFrom, randFrom.clone().add(dst));
                        eff.setOverlayColor(new Color(3007488));
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playOuterCube(FissureData drawData) {
        if (drawData == null) {
            return;
        }
        int max = 0;
        BlockPos minV = drawData.getMin();
        BlockPos maxV = drawData.getMax();
        if (Math.abs(minV.func_177958_n()) > max) {
            max = Math.abs(minV.func_177958_n());
        }
        if (Math.abs(minV.func_177956_o()) > max) {
            max = Math.abs(minV.func_177956_o());
        }
        if (Math.abs(minV.func_177952_p()) > max) {
            max = Math.abs(minV.func_177952_p());
        }
        if (Math.abs(maxV.func_177958_n()) > max) {
            max = Math.abs(maxV.func_177958_n());
        }
        if (Math.abs(maxV.func_177956_o()) > max) {
            max = Math.abs(maxV.func_177956_o());
        }
        if (Math.abs(maxV.func_177952_p()) > max) {
            max = Math.abs(maxV.func_177952_p());
        }
        if (this.outerFloatingCube1 == null || ((EntityFXFloatingCube)this.outerFloatingCube1).isRemoved()) {
            this.outerFloatingCube1 = this.setupOuterCube(max);
        }
        if (this.outerFloatingCube2 == null || ((EntityFXFloatingCube)this.outerFloatingCube2).isRemoved()) {
            this.outerFloatingCube2 = this.setupOuterCube(max);
        }
        this.handleOuterAnimations(this.outerFloatingCube1, max);
        this.handleOuterAnimations(this.outerFloatingCube2, max);
    }

    @SideOnly(value=Side.CLIENT)
    private Object setupOuterCube(int radius) {
        EntityFXFloatingCube cube = new EntityFXFloatingCube(10, AssetLibrary.loadTexture(AssetLoader.TextureLocation.BLOCKS, "core_edge"));
        cube.setRefreshFunction(() -> Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.field_70170_p.field_73011_w.getDimension() == this.field_145850_b.field_73011_w.getDimension() && Minecraft.func_71410_x().field_71441_e.func_175625_s(this.func_174877_v()) instanceof TileFissureDevice && !Minecraft.func_71410_x().field_71441_e.func_175625_s(this.func_174877_v()).func_145837_r() && ((TileFissureDevice)Minecraft.func_71410_x().field_71441_e.func_175625_s(this.func_174877_v())).getStructureDepth() > 0 && Minecraft.func_71410_x().field_71441_e.func_175625_s(this.func_174877_v()) == this);
        cube.setAlphaMultiplier(0.0f);
        cube.setPosition(new Vector3(this.func_174877_v()).add(0.5, 0.5, 0.5));
        cube.setScale(radius * 2);
        cube.setTumbleIntensityMultiplier(0.04f);
        cube.setColor(new Color(3007488));
        cube.tumble();
        EffectHandler.getInstance().registerFX(cube);
        return cube;
    }

    @SideOnly(value=Side.CLIENT)
    private void handleOuterAnimations(Object cubeObj, int radius) {
        EntityFXFloatingCube cube = (EntityFXFloatingCube)cubeObj;
        cube.setTumbleIntensityMultiplier(0.04f);
        cube.setScale((radius + 2) * 2);
        float add = 0.00175f;
        float remove = 0.00625f;
        if (this.percDrawFissure >= 0.75f) {
            float val = Math.min(0.15f, cube.getAlphaMultiplier() + add);
            if (this.swapPerc > 0.0f) {
                val = Math.max(val, this.swapPerc);
            }
            cube.setAlphaMultiplier(val);
        } else {
            cube.setAlphaMultiplier(Math.max(0.0f, cube.getAlphaMultiplier() - remove));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void handleAnimations(Object cubeObj) {
        EntityFXFloatingCube cube = (EntityFXFloatingCube)cubeObj;
        cube.setTumbleIntensityMultiplier(this.percActive * 0.6f);
        cube.setAlphaMultiplier(1.0f - (1.0f - (0.8f + 0.2f * this.percActive)));
        Color result = new Color(39 + (int)(7.0f * this.percActive), 39 + (int)(173.0f * this.percActive), 39 + (int)(-39.0f * this.percActive));
        cube.setColor(result);
    }

    @SideOnly(value=Side.CLIENT)
    private Object setupCube(float baseScale, float scaleGrow) {
        EntityFXFloatingCube cube = new EntityFXFloatingCube(10, AssetLibrary.loadTexture(AssetLoader.TextureLocation.BLOCKS, "core_edge"));
        cube.setRefreshFunction(() -> Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.field_70170_p.field_73011_w.getDimension() == this.field_145850_b.field_73011_w.getDimension() && Minecraft.func_71410_x().field_71441_e.func_175625_s(this.func_174877_v()) instanceof TileFissureDevice && !Minecraft.func_71410_x().field_71441_e.func_175625_s(this.func_174877_v()).func_145837_r() && ((TileFissureDevice)Minecraft.func_71410_x().field_71441_e.func_175625_s(this.func_174877_v())).getStructureDepth() > 0 && Minecraft.func_71410_x().field_71441_e.func_175625_s(this.func_174877_v()) == this);
        cube.setPosition(new Vector3(this).add(0.5, 0.8, 0.5));
        cube.setPositionController((fx, position, motionToBeMoved) -> {
            Vector3 base = new Vector3(this).add(0.5, 0.8, 0.5);
            base.addY((double)this.percActive * 0.5);
            return base;
        });
        cube.setScaleFunction((fx, pTicks, scaleIn) -> baseScale + baseScale * (this.percActive * scaleGrow));
        cube.tumble();
        EffectHandler.getInstance().registerFX(cube);
        return cube;
    }

    public int getTicksExisted() {
        return this.ticksExisted;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        AxisAlignedBB box = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).func_186670_a(this.field_174879_c);
        box.func_186662_g((double)(Math.max(0, this.getStructureDepth()) * 4 + 1));
        return box;
    }

    @Override
    public void writeNetNBT(NBTTagCompound compound) {
        super.writeNetNBT(compound);
        compound.func_74757_a("active", this.active);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74757_a("swap", this.inSwap);
        compound.func_74776_a("swapPerc", this.swapPerc);
    }

    @Override
    public void readNetNBT(NBTTagCompound compound) {
        super.readNetNBT(compound);
        this.active = compound.func_74767_n("active");
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.inSwap = compound.func_74767_n("swap");
        this.swapPerc = compound.func_74760_g("swapPerc");
    }
}

