/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.fracture.common.registry.internal;

import hellfirepvp.fracture.common.registry.RegistryBlocks;
import hellfirepvp.fracture.common.registry.RegistryItems;
import hellfirepvp.fracture.common.registry.RegistryRecipes;
import hellfirepvp.fracture.common.registry.RegistrySounds;
import hellfirepvp.fracture.common.registry.internal.RegistryPrimer;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistryHandler {
    private RegistryPrimer registry;

    public RegistryHandler(RegistryPrimer registry) {
        this.registry = registry;
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        this.registry.wipe(event.getClass());
        RegistryItems.init();
        this.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        this.registry.wipe(event.getClass());
        RegistryBlocks.init();
        RegistryBlocks.initRenderRegistry();
        this.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        this.registry.wipe(event.getClass());
        RegistryRecipes.init();
        this.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
    }

    @SubscribeEvent
    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        this.registry.wipe(event.getClass());
        RegistrySounds.init();
        this.fillRegistry(event.getRegistry().getRegistrySuperType(), event.getRegistry());
    }

    private <T extends IForgeRegistryEntry<T>> void fillRegistry(Class<T> registrySuperType, IForgeRegistry<T> forgeRegistry) {
        List<?> entries = this.registry.getEntries(registrySuperType);
        if (entries != null) {
            entries.forEach(e -> forgeRegistry.register((IForgeRegistryEntry)e));
        }
    }
}

