/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.fracture.common.registry;

import hellfirepvp.fracture.Fracture;
import hellfirepvp.fracture.common.CommonProxy;
import hellfirepvp.fracture.common.block.BlockFissureDevice;
import hellfirepvp.fracture.common.block.BlockFissureDeviceBase;
import hellfirepvp.fracture.common.block.BlockFissureDevicePillar;
import hellfirepvp.fracture.common.lib.BlocksFR;
import hellfirepvp.fracture.common.tile.TileFissureDevice;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class RegistryBlocks {
    public static List<Block> blocks = new LinkedList<Block>();

    public static void init() {
        RegistryBlocks.registerBlocks();
        RegistryBlocks.registerTiles();
    }

    private static void registerBlocks() {
        BlocksFR.fissureDeviceBase = RegistryBlocks.registerBlock(new BlockFissureDeviceBase());
        RegistryBlocks.queueDefaultItemBlock(BlocksFR.fissureDeviceBase);
        BlocksFR.fissureDevicePillar = RegistryBlocks.registerBlock(new BlockFissureDevicePillar());
        RegistryBlocks.queueDefaultItemBlock(BlocksFR.fissureDevicePillar);
        BlocksFR.fissureDeviceHead = RegistryBlocks.registerBlock(new BlockFissureDevice());
        RegistryBlocks.queueDefaultItemBlock((Block)BlocksFR.fissureDeviceHead);
    }

    public static void initRenderRegistry() {
    }

    private static void registerTiles() {
        RegistryBlocks.registerTile(TileFissureDevice.class);
    }

    public static void queueDefaultItemBlock(Block block) {
        blocks.add(block);
    }

    private static <T extends Block> T registerBlock(T block, String name) {
        CommonProxy.registryPrimer.register(block.func_149663_c(name).setRegistryName(name));
        return block;
    }

    public static <T extends Block> T registerBlock(T block) {
        return RegistryBlocks.registerBlock(block, block.getClass().getSimpleName().toLowerCase());
    }

    private static void registerBlockRender(Block block) {
        Fracture.proxy.registerVariantName(Item.func_150898_a((Block)block), block.func_149739_a());
        Fracture.proxy.registerBlockRender(block, 0, block.func_149739_a());
    }

    private static void registerTile(Class<? extends TileEntity> tile, String name) {
        GameRegistry.registerTileEntity(tile, (String)name);
    }

    public static void registerTile(Class<? extends TileEntity> tile) {
        RegistryBlocks.registerTile(tile, tile.getSimpleName().toLowerCase());
    }

    public static class FluidCustomModelMapper
    extends StateMapperBase
    implements ItemMeshDefinition {
        private final ModelResourceLocation res;

        public FluidCustomModelMapper(Fluid f) {
            this.res = new ModelResourceLocation("fracture".toLowerCase() + ":blockfluids", f.getName());
        }

        public ModelResourceLocation func_178113_a(ItemStack stack) {
            return this.res;
        }

        public ModelResourceLocation func_178132_a(IBlockState state) {
            return this.res;
        }
    }
}

