/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.fracture.common.net.packet;

import hellfirepvp.fracture.Fracture;
import hellfirepvp.fracture.common.data.AbstractData;
import hellfirepvp.fracture.common.data.SyncDataHolder;
import hellfirepvp.fracture.common.util.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTSizeTracker;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PktSyncData
implements IMessage,
IMessageHandler<PktSyncData, IMessage> {
    private Map<String, AbstractData> data = new HashMap<String, AbstractData>();
    private boolean shouldSyncAll = false;

    public PktSyncData() {
    }

    public PktSyncData(Map<String, AbstractData> dataToSend, boolean shouldSyncAll) {
        this.data = dataToSend;
        this.shouldSyncAll = shouldSyncAll;
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            NBTTagCompound cmp;
            String key = ByteBufUtils.readString(buf);
            byte providerId = buf.readByte();
            AbstractData.AbstractDataProvider<? extends AbstractData> provider = AbstractData.Registry.getProvider(providerId);
            if (provider == null) {
                Fracture.log.warn("[Fracture] Provider for ID " + providerId + " doesn't exist! Skipping...");
                continue;
            }
            try {
                cmp = CompressedStreamTools.func_152456_a((DataInput)new ByteBufInputStream(buf), (NBTSizeTracker)NBTSizeTracker.field_152451_a);
            }
            catch (IOException e) {
                Fracture.log.warn("[Fracture] Provider Compound of " + providerId + " threw an IOException! Skipping...");
                Fracture.log.warn("[Fracture] Exception message: " + e.getMessage());
                continue;
            }
            AbstractData dat = provider.provideNewInstance();
            dat.readRawFromPacket(cmp);
            this.data.put(key, dat);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.data.size());
        for (String key : this.data.keySet()) {
            AbstractData dat = this.data.get(key);
            NBTTagCompound cmp = new NBTTagCompound();
            if (this.shouldSyncAll) {
                dat.writeAllDataToPacket(cmp);
            } else {
                dat.writeToPacket(cmp);
            }
            ByteBufUtils.writeString(buf, key);
            byte providerId = dat.getProviderID();
            buf.writeByte((int)providerId);
            try {
                CompressedStreamTools.func_74800_a((NBTTagCompound)cmp, (DataOutput)new ByteBufOutputStream(buf));
            }
            catch (IOException iOException) {}
        }
    }

    public IMessage onMessage(PktSyncData message, MessageContext ctx) {
        Fracture.proxy.scheduleClientside(() -> SyncDataHolder.receiveServerPacket(message.data));
        return null;
    }
}

