/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.fracture.common.fissure.swap;

import hellfirepvp.fracture.Fracture;
import hellfirepvp.fracture.common.util.tick.ITickHandler;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class FissureSwapPreparation
implements ITickHandler,
ForgeChunkManager.LoadingCallback {
    public static FissureSwapPreparation INSTANCE = new FissureSwapPreparation();
    private Map<Integer, Map<BlockPos, TimeoutTicket>> ticketBuffer = new HashMap<Integer, Map<BlockPos, TimeoutTicket>>();

    private FissureSwapPreparation() {
    }

    @Override
    public void tick(TickEvent.Type type, Object ... context) {
        for (Integer dim : this.ticketBuffer.keySet()) {
            Map<BlockPos, TimeoutTicket> tickets = this.ticketBuffer.get(dim);
            for (Map.Entry<BlockPos, TimeoutTicket> ticketEntry : tickets.entrySet()) {
                TimeoutTicket ticket = ticketEntry.getValue();
                ticket.tick++;
                if (ticket.tick < 30) continue;
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket.ticket);
                tickets.remove(ticketEntry.getKey());
            }
        }
    }

    public static void removeTicket(int dim, BlockPos offsetTicketHolder) {
        Map ticketMap = FissureSwapPreparation.INSTANCE.ticketBuffer.computeIfAbsent(dim, ignored -> new HashMap());
        TimeoutTicket ticket = (TimeoutTicket)ticketMap.remove(offsetTicketHolder);
        if (ticket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket.ticket);
        }
    }

    public static void updateTicket(int dim, BlockPos offsetMin, BlockPos offsetMax, BlockPos offsetTicketHolder) {
        Map ticketMap = FissureSwapPreparation.INSTANCE.ticketBuffer.computeIfAbsent(dim, ignored -> new HashMap());
        TimeoutTicket ticket = (TimeoutTicket)ticketMap.get(offsetTicketHolder);
        if (ticket != null) {
            ticket.tick = 0;
        } else {
            FissureSwapPreparation.prepareChunks(dim, offsetMin, offsetMax, offsetTicketHolder);
        }
    }

    private static void prepareChunks(int dim, BlockPos offsetMin, BlockPos offsetMax, BlockPos offsetTicketHolder) {
        WorldServer world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(dim);
        ForgeChunkManager.Ticket loadingTicket = ForgeChunkManager.requestTicket((Object)Fracture.INSTANCE, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        BlockPos flatMin = new BlockPos(offsetMin.func_177958_n(), 0, offsetMin.func_177952_p());
        BlockPos flatMax = new BlockPos(offsetMax.func_177958_n(), 0, offsetMax.func_177952_p());
        LinkedList<ChunkPos> chunks = new LinkedList<ChunkPos>();
        for (BlockPos pos : BlockPos.func_177975_b((BlockPos)flatMin, (BlockPos)flatMax)) {
            ChunkPos ch2 = new ChunkPos(pos);
            if (chunks.contains(ch2)) continue;
            chunks.add(ch2);
        }
        chunks.forEach(ch -> ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)loadingTicket, (ChunkPos)ch));
        TimeoutTicket newTicket = new TimeoutTicket(loadingTicket);
        Map ticketMap = FissureSwapPreparation.INSTANCE.ticketBuffer.computeIfAbsent(dim, ignored -> new HashMap());
        TimeoutTicket previousTicket = ticketMap.put(offsetTicketHolder, newTicket);
        if (previousTicket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)previousTicket.ticket);
        }
    }

    @Override
    public EnumSet<TickEvent.Type> getHandledTypes() {
        return EnumSet.of(TickEvent.Type.SERVER);
    }

    @Override
    public boolean canFire(TickEvent.Phase phase) {
        return phase == TickEvent.Phase.END;
    }

    @Override
    public String getName() {
        return "Swap Preparation";
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        tickets.forEach(ForgeChunkManager::releaseTicket);
    }

    public static void cleanUpServer() {
        FissureSwapPreparation.INSTANCE.ticketBuffer.clear();
    }

    private static class TimeoutTicket {
        private int tick = 0;
        private final ForgeChunkManager.Ticket ticket;

        private TimeoutTicket(ForgeChunkManager.Ticket ticket) {
            this.ticket = ticket;
        }
    }
}

