/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.fracture.common.fissure.swap;

import hellfirepvp.fracture.common.fissure.FissureData;
import hellfirepvp.fracture.common.fissure.FissureDataController;
import hellfirepvp.fracture.common.fissure.swap.FissureSwapPreparation;
import hellfirepvp.fracture.common.tile.TileFissureDevice;
import hellfirepvp.fracture.common.util.MiscUtils;
import hellfirepvp.fracture.common.util.Vector3;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class FissureSwapHelper {
    public static boolean prepareSwap(TileFissureDevice device) {
        BlockPos linkedPos;
        BlockPos originPos;
        int originDim = device.func_145831_w().field_73011_w.getDimension();
        FissureData originData = FissureDataController.getFissureData(originDim, originPos = device.func_174877_v());
        if (originData == null || !originData.hasOtherLink()) {
            return false;
        }
        int linkedDim = originData.getOtherLinkDim();
        FissureData targetData = FissureDataController.getFissureData(linkedDim, linkedPos = originData.getOtherLinkPos());
        if (targetData == null) {
            return false;
        }
        BlockPos originMin = originData.getMin();
        BlockPos originMax = originData.getMax();
        BlockPos targetMin = targetData.getMin();
        BlockPos targetMax = targetData.getMax();
        BlockPos minOffset = new BlockPos(originMin.func_177958_n() < targetMin.func_177958_n() ? originMin.func_177958_n() : targetMin.func_177958_n(), originMin.func_177956_o() < targetMin.func_177956_o() ? originMin.func_177956_o() : targetMin.func_177956_o(), originMin.func_177952_p() < targetMin.func_177952_p() ? originMin.func_177952_p() : targetMin.func_177952_p());
        BlockPos maxOffset = new BlockPos(originMax.func_177958_n() > targetMax.func_177958_n() ? originMax.func_177958_n() : targetMax.func_177958_n(), originMax.func_177956_o() > targetMax.func_177956_o() ? originMax.func_177956_o() : targetMax.func_177956_o(), originMax.func_177952_p() > targetMax.func_177952_p() ? originMax.func_177952_p() : targetMax.func_177952_p());
        FissureSwapPreparation.updateTicket(originDim, minOffset.func_177971_a((Vec3i)originPos), maxOffset.func_177971_a((Vec3i)originPos), originPos);
        FissureSwapPreparation.updateTicket(linkedDim, minOffset.func_177971_a((Vec3i)linkedPos), maxOffset.func_177971_a((Vec3i)linkedPos), linkedPos);
        return true;
    }

    public static boolean doSwap(TileFissureDevice device) {
        Vector3 to;
        BlockPos linkedPos;
        BlockPos originPos;
        int originDim = device.func_145831_w().field_73011_w.getDimension();
        FissureData originData = FissureDataController.getFissureData(originDim, originPos = device.func_174877_v());
        if (originData == null || !originData.hasOtherLink()) {
            return false;
        }
        int linkedDim = originData.getOtherLinkDim();
        FissureData targetData = FissureDataController.getFissureData(linkedDim, linkedPos = originData.getOtherLinkPos());
        if (targetData == null) {
            return false;
        }
        BlockPos originMin = originData.getMin();
        BlockPos originMax = originData.getMax();
        BlockPos targetMin = targetData.getMin();
        BlockPos targetMax = targetData.getMax();
        BlockPos minOffset = new BlockPos(originMin.func_177958_n() < targetMin.func_177958_n() ? originMin.func_177958_n() : targetMin.func_177958_n(), originMin.func_177956_o() < targetMin.func_177956_o() ? originMin.func_177956_o() : targetMin.func_177956_o(), originMin.func_177952_p() < targetMin.func_177952_p() ? originMin.func_177952_p() : targetMin.func_177952_p());
        BlockPos maxOffset = new BlockPos(originMax.func_177958_n() > targetMax.func_177958_n() ? originMax.func_177958_n() : targetMax.func_177958_n(), originMax.func_177956_o() > targetMax.func_177956_o() ? originMax.func_177956_o() : targetMax.func_177956_o(), originMax.func_177952_p() > targetMax.func_177952_p() ? originMax.func_177952_p() : targetMax.func_177952_p());
        WorldServer originWorld = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(originDim);
        WorldServer targetWorld = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(linkedDim);
        AxisAlignedBB boxOrigin = new AxisAlignedBB(minOffset.func_177971_a((Vec3i)originPos), maxOffset.func_177971_a((Vec3i)originPos));
        AxisAlignedBB boxTarget = new AxisAlignedBB(minOffset.func_177971_a((Vec3i)linkedPos), maxOffset.func_177971_a((Vec3i)linkedPos));
        LinkedList<BlockPos> ignoreOffsets = new LinkedList<BlockPos>();
        HashMap<BlockPos, IBlockState> realOffsetStates = new HashMap<BlockPos, IBlockState>();
        for (Object pos : BlockPos.func_177980_a((BlockPos)minOffset.func_177971_a((Vec3i)originPos), (BlockPos)maxOffset.func_177971_a((Vec3i)originPos))) {
            IBlockState iBlockState = originWorld.func_180495_p((BlockPos)pos);
            if (originWorld.func_175625_s((BlockPos)pos) == null && iBlockState.func_185887_b((World)originWorld, (BlockPos)pos) >= 0.0f) {
                realOffsetStates.put(pos.func_177973_b((Vec3i)originPos), iBlockState);
                continue;
            }
            ignoreOffsets.add(pos.func_177973_b((Vec3i)originPos));
        }
        HashMap<BlockPos, IBlockState> targetOffsetStates = new HashMap<BlockPos, IBlockState>();
        for (BlockPos blockPos : BlockPos.func_177980_a((BlockPos)minOffset.func_177971_a((Vec3i)linkedPos), (BlockPos)maxOffset.func_177971_a((Vec3i)linkedPos))) {
            if (ignoreOffsets.contains(blockPos.func_177973_b((Vec3i)linkedPos))) continue;
            IBlockState from = targetWorld.func_180495_p(blockPos);
            if (targetWorld.func_175625_s(blockPos) == null && from.func_185887_b((World)targetWorld, blockPos) >= 0.0f) {
                targetOffsetStates.put(blockPos.func_177973_b((Vec3i)linkedPos), from);
                continue;
            }
            realOffsetStates.remove(blockPos.func_177973_b((Vec3i)linkedPos));
        }
        for (Map.Entry entry : realOffsetStates.entrySet()) {
            targetWorld.func_175656_a(((BlockPos)entry.getKey()).func_177971_a((Vec3i)linkedPos), (IBlockState)entry.getValue());
        }
        for (Map.Entry entry : targetOffsetStates.entrySet()) {
            originWorld.func_175656_a(((BlockPos)entry.getKey()).func_177971_a((Vec3i)originPos), (IBlockState)entry.getValue());
        }
        List originEntities = originWorld.func_72872_a(EntityPlayer.class, boxOrigin);
        List list = targetWorld.func_72872_a(EntityPlayer.class, boxTarget);
        for (EntityPlayer e : originEntities) {
            to = Vector3.atEntityCorner((Entity)e).subtract((Vec3i)originPos).add((Vec3i)linkedPos);
            MiscUtils.transferEntityTo((Entity)e, linkedDim, to);
        }
        for (EntityPlayer e : list) {
            to = Vector3.atEntityCorner((Entity)e).subtract((Vec3i)linkedPos).add((Vec3i)originPos);
            MiscUtils.transferEntityTo((Entity)e, originDim, to);
        }
        FissureSwapPreparation.removeTicket(originDim, originPos);
        FissureSwapPreparation.removeTicket(linkedDim, linkedPos);
        return true;
    }
}

