/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.fracture.common.fissure;

import hellfirepvp.fracture.common.data.DataFissures;
import hellfirepvp.fracture.common.data.SyncDataHolder;
import hellfirepvp.fracture.common.fissure.FissureData;
import hellfirepvp.fracture.common.fissure.FissureDataAccessor;
import hellfirepvp.fracture.common.tile.TileFissureDevice;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FissureDataController {
    private static final Random rand = new Random();
    private static Map<Integer, Map<BlockPos, FissureData>> fissures = new HashMap<Integer, Map<BlockPos, FissureData>>();
    private static boolean dirty = false;
    private static boolean initialized = false;

    public static Map<Integer, Map<BlockPos, FissureData>> getFissures() {
        return fissures;
    }

    public static void setup() {
        if (initialized) {
            return;
        }
        initialized = true;
        fissures = FissureDataAccessor.load();
    }

    public static void cleanUpServer() {
        initialized = false;
        fissures = new HashMap<Integer, Map<BlockPos, FissureData>>();
    }

    public static void scheduleSave() {
        if (dirty) {
            FissureDataAccessor.save(fissures);
            dirty = false;
        }
    }

    @Nullable
    public static Tuple<Integer, BlockPos> getRandomFissureExcept(TileFissureDevice device) {
        BlockPos offset;
        int dim = device.func_145831_w().field_73011_w.getDimension();
        FissureData ownFissure = FissureDataController.getFissureData(dim, offset = device.func_174877_v());
        if (ownFissure == null) {
            return null;
        }
        LinkedList<Tuple> foundFissureData = new LinkedList<Tuple>();
        for (int registeredDim : fissures.keySet()) {
            Map<BlockPos, FissureData> fissureMap = fissures.get(registeredDim);
            for (BlockPos registeredOffset : fissureMap.keySet()) {
                foundFissureData.add(new Tuple((Object)registeredDim, (Object)registeredOffset));
            }
        }
        Collections.shuffle(foundFissureData, rand);
        for (int maxTries = foundFissureData.size(); maxTries > 0; --maxTries) {
            Tuple test = (Tuple)foundFissureData.pop();
            if ((Integer)test.func_76341_a() == dim && ((BlockPos)test.func_76340_b()).equals((Object)offset)) continue;
            FissureData data = fissures.get(test.func_76341_a()).get(test.func_76340_b());
            if (data.hasOtherLink()) continue;
            data.updateLink(dim, offset);
            ownFissure.updateLink((Integer)test.func_76341_a(), (BlockPos)test.func_76340_b());
            ((DataFissures)SyncDataHolder.getDataServer("FissureData")).updateFissure((Integer)test.func_76341_a(), (BlockPos)test.func_76340_b(), data);
            ((DataFissures)SyncDataHolder.getDataServer("FissureData")).updateFissure(dim, offset, ownFissure);
            return test;
        }
        return null;
    }

    public static void updateFissureServer(TileFissureDevice device) {
        Map<BlockPos, IBlockState> fissureBlocks;
        World world = device.func_145831_w();
        BlockPos offset = device.func_174877_v();
        FissureData ownFissureData = FissureDataController.getFissureData(world.field_73011_w.getDimension(), offset);
        if (ownFissureData == null) {
            ownFissureData = new FissureData();
        }
        if (!ownFissureData.containsEqualBlocks(fissureBlocks = device.getOffsetRangeData(ownFissureData.getStateOffsetMap()))) {
            ownFissureData = new FissureData(ownFissureData.hasOtherLink(), ownFissureData.getOtherLinkDim(), ownFissureData.getOtherLinkPos());
            ownFissureData.putAll(fissureBlocks);
            fissures.computeIfAbsent(world.field_73011_w.getDimension(), dim -> new HashMap()).put(offset, ownFissureData);
            ((DataFissures)SyncDataHolder.getDataServer("FissureData")).updateFissure(world.field_73011_w.getDimension(), offset, ownFissureData);
            dirty = true;
        }
    }

    public static void removeFissureServer(World worldIn, BlockPos pos) {
        FissureData ownData;
        Map<BlockPos, FissureData> dimMap = fissures.get(worldIn.field_73011_w.getDimension());
        if (dimMap != null && (ownData = dimMap.get(pos)) != null) {
            BlockPos otherLinkPos;
            int otherLinkDim;
            FissureData otherData;
            if (ownData.hasOtherLink() && (otherData = FissureDataController.getFissureData(otherLinkDim = ownData.getOtherLinkDim(), otherLinkPos = ownData.getOtherLinkPos())) != null) {
                otherData.removeLink();
                ((DataFissures)SyncDataHolder.getDataServer("FissureData")).updateFissure(otherLinkDim, otherLinkPos, otherData);
            }
            ownData.removeLink();
            ((DataFissures)SyncDataHolder.getDataServer("FissureData")).updateFissure(worldIn.field_73011_w.getDimension(), pos, ownData);
            dimMap.remove(pos);
            ((DataFissures)SyncDataHolder.getDataServer("FissureData")).removeFissure(worldIn.field_73011_w.getDimension(), pos);
            dirty = true;
        }
    }

    @Nullable
    public static FissureData getFissureData(int dimension, BlockPos pos) {
        Map<BlockPos, FissureData> dat = fissures.get(dimension);
        if (dat == null) {
            return null;
        }
        return dat.get(pos);
    }

    @SideOnly(value=Side.CLIENT)
    public static void addFissureClient(int dimension, BlockPos offset, FissureData data) {
        Map map = fissures.computeIfAbsent(dimension, dim -> new HashMap());
        FissureData old = map.put(offset, data);
        if (old != null) {
            old.cleanUp();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void removeFissureClient(int dimension, BlockPos offset) {
        Map map = fissures.computeIfAbsent(dimension, dim -> new HashMap());
        FissureData f = (FissureData)map.remove(offset);
        if (f != null) {
            f.cleanUp();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void cleanUp() {
        fissures.values().forEach(m -> m.values().forEach(FissureData::cleanUp));
        fissures.clear();
    }
}

