/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.fracture.common.fissure;

import hellfirepvp.fracture.common.fissure.FissureData;
import hellfirepvp.fracture.common.util.FileStorageUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;

public class FissureDataAccessor {
    private static File getFissureDataFile() {
        File dir = FileStorageUtil.getGeneralSubDirectory("fissuredata");
        File data = new File(dir, "fissures.dat");
        return data;
    }

    public static Map<Integer, Map<BlockPos, FissureData>> load() {
        HashMap<Integer, Map<BlockPos, FissureData>> dimMap = new HashMap<Integer, Map<BlockPos, FissureData>>();
        File file = FissureDataAccessor.getFissureDataFile();
        try {
            NBTTagCompound nbt = CompressedStreamTools.func_74797_a((File)file);
            NBTTagList dimList = nbt.func_150295_c("dims", 10);
            for (int j = 0; j < dimList.func_74745_c(); ++j) {
                NBTTagCompound dimTag = dimList.func_150305_b(j);
                int dim = dimTag.func_74762_e("dim");
                HashMap<BlockPos, FissureData> map = new HashMap<BlockPos, FissureData>();
                dimMap.put(dim, map);
                NBTTagList elements = dimTag.func_150295_c("list", 10);
                for (int i = 0; i < elements.func_74745_c(); ++i) {
                    NBTTagCompound fissureData = elements.func_150305_b(i);
                    BlockPos pos = new BlockPos(fissureData.func_74762_e("x"), fissureData.func_74762_e("y"), fissureData.func_74762_e("z"));
                    NBTTagCompound data = fissureData.func_74775_l("data");
                    FissureData fissure = FissureData.readFromNBT(data);
                    map.put(pos, fissure);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dimMap;
    }

    public static void save(Map<Integer, Map<BlockPos, FissureData>> data) {
        NBTTagCompound store = new NBTTagCompound();
        NBTTagList dimList = new NBTTagList();
        for (Map.Entry<Integer, Map<BlockPos, FissureData>> dimEntry : data.entrySet()) {
            NBTTagCompound dimTag = new NBTTagCompound();
            dimTag.func_74768_a("dim", dimEntry.getKey().intValue());
            NBTTagList list = new NBTTagList();
            for (Map.Entry<BlockPos, FissureData> entry : dimEntry.getValue().entrySet()) {
                NBTTagCompound cmp = new NBTTagCompound();
                cmp.func_74768_a("x", entry.getKey().func_177958_n());
                cmp.func_74768_a("y", entry.getKey().func_177956_o());
                cmp.func_74768_a("z", entry.getKey().func_177952_p());
                NBTTagCompound fissureData = new NBTTagCompound();
                entry.getValue().writeToNBT(fissureData);
                cmp.func_74782_a("data", (NBTBase)fissureData);
                list.func_74742_a((NBTBase)cmp);
            }
            dimTag.func_74782_a("list", (NBTBase)list);
            dimList.func_74742_a((NBTBase)dimTag);
        }
        store.func_74782_a("dims", (NBTBase)dimList);
        File storeFile = FissureDataAccessor.getFissureDataFile();
        try {
            CompressedStreamTools.func_74795_b((NBTTagCompound)store, (File)storeFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

