/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.fracture.common.fissure;

import com.google.common.collect.ImmutableMap;
import hellfirepvp.fracture.client.util.WorldBlockArrayRenderAccess;
import hellfirepvp.fracture.common.util.MiscUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FissureData {
    private Map<BlockPos, IBlockState> stateOffsetMap = new HashMap<BlockPos, IBlockState>();
    private boolean hasOtherLink = false;
    private int otherLinkDim = -1;
    private BlockPos otherLinkPos = BlockPos.field_177992_a;
    private BlockPos min = null;
    private BlockPos max = null;
    private int hashVal = -1;
    private int clientBatchIdNormal = -1;
    private int clientBatchIdTransparent = -1;

    public FissureData() {
        this(false, -1, BlockPos.field_177992_a);
    }

    public FissureData(boolean hasOtherLink, int otherLinkDim, BlockPos otherLinkPos) {
        this.hasOtherLink = hasOtherLink;
        this.otherLinkDim = otherLinkDim;
        this.otherLinkPos = otherLinkPos;
    }

    void put(BlockPos offset, IBlockState state) {
        this.stateOffsetMap.put(offset, state);
        this.hashVal = -1;
        this.max = null;
        this.min = null;
    }

    void putAll(Map<BlockPos, IBlockState> states) {
        states.forEach(this::put);
    }

    public BlockPos getMin() {
        if (this.min == null) {
            this.recalcSize();
        }
        return this.min;
    }

    public BlockPos getMax() {
        if (this.max == null) {
            this.recalcSize();
        }
        return this.max;
    }

    public boolean isInRange(BlockPos pos, BlockPos thisOffset) {
        BlockPos thisMin = this.getMin().func_177971_a((Vec3i)thisOffset);
        BlockPos thisMax = this.getMax().func_177971_a((Vec3i)thisOffset);
        return thisMin.func_177958_n() <= pos.func_177958_n() && thisMin.func_177956_o() <= pos.func_177956_o() && thisMin.func_177952_p() <= pos.func_177952_p() && thisMax.func_177958_n() >= pos.func_177958_n() && thisMax.func_177956_o() >= pos.func_177956_o() && thisMax.func_177952_p() >= pos.func_177952_p();
    }

    private void recalcSize() {
        int minX = MiscUtils.getMinEntry(this.stateOffsetMap.keySet(), Vec3i::func_177958_n);
        int minY = MiscUtils.getMinEntry(this.stateOffsetMap.keySet(), Vec3i::func_177956_o);
        int minZ = MiscUtils.getMinEntry(this.stateOffsetMap.keySet(), Vec3i::func_177952_p);
        int maxX = MiscUtils.getMaxEntry(this.stateOffsetMap.keySet(), Vec3i::func_177958_n);
        int maxY = MiscUtils.getMaxEntry(this.stateOffsetMap.keySet(), Vec3i::func_177956_o);
        int maxZ = MiscUtils.getMaxEntry(this.stateOffsetMap.keySet(), Vec3i::func_177952_p);
        this.min = new BlockPos(minX, minY, minZ);
        this.max = new BlockPos(maxX, maxY, maxZ);
    }

    public int getHash(BlockPos offset, IBlockAccess exclusions) {
        if (this.hashVal != -1) {
            return this.hashVal;
        }
        int hash = 80238287;
        for (Map.Entry<BlockPos, IBlockState> tbs : this.stateOffsetMap.entrySet()) {
            if (exclusions.func_180495_p(tbs.getKey().func_177971_a((Vec3i)offset)).func_177230_c() instanceof BlockAir) continue;
            hash = hash << 4 ^ hash >> 28 ^ tbs.getKey().func_177958_n() * 5449 % 130651;
            hash = hash << 4 ^ hash >> 28 ^ tbs.getKey().func_177956_o() * 5429 % 130651;
            hash = hash << 4 ^ hash >> 28 ^ tbs.getKey().func_177952_p() * 5449 % 130651;
            hash = hash << 4 ^ hash >> 28 ^ tbs.getValue().hashCode() * 5949 % 13595151;
        }
        this.hashVal = hash;
        return this.hashVal;
    }

    public Map<BlockPos, IBlockState> getStateOffsetMap() {
        return ImmutableMap.copyOf(this.stateOffsetMap);
    }

    @SideOnly(value=Side.CLIENT)
    @Deprecated
    public void refreshBatch() {
        if (this.clientBatchIdNormal == -1) {
            Block block;
            IBlockState state;
            WorldBlockArrayRenderAccess access = new WorldBlockArrayRenderAccess((IBlockAccess)Minecraft.func_71410_x().field_71441_e, (IBlockAccess)Minecraft.func_71410_x().field_71441_e);
            access.setOffsetBlockStates(this.stateOffsetMap);
            BlockRendererDispatcher brd = Minecraft.func_71410_x().func_175602_ab();
            Tessellator tes = Tessellator.func_178181_a();
            BufferBuilder vb = tes.func_178180_c();
            this.clientBatchIdNormal = GLAllocation.func_74526_a((int)1);
            GlStateManager.func_187423_f((int)this.clientBatchIdNormal, (int)4864);
            vb.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            for (BlockPos key : this.stateOffsetMap.keySet()) {
                state = this.stateOffsetMap.get(key);
                block = state.func_177230_c();
                for (BlockRenderLayer brl : BlockRenderLayer.values()) {
                    if (!block.canRenderInLayer(state, brl) || brl == BlockRenderLayer.TRANSLUCENT) continue;
                    ForgeHooksClient.setRenderLayer((BlockRenderLayer)brl);
                    brd.func_175018_a(state, key, (IBlockAccess)access, vb);
                    ForgeHooksClient.setRenderLayer(null);
                }
            }
            tes.func_78381_a();
            GlStateManager.func_187415_K();
            this.clientBatchIdTransparent = GLAllocation.func_74526_a((int)1);
            GlStateManager.func_187423_f((int)this.clientBatchIdTransparent, (int)4864);
            vb.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            for (BlockPos key : this.stateOffsetMap.keySet()) {
                state = this.stateOffsetMap.get(key);
                block = state.func_177230_c();
                if (!block.canRenderInLayer(state, BlockRenderLayer.TRANSLUCENT)) continue;
                ForgeHooksClient.setRenderLayer((BlockRenderLayer)BlockRenderLayer.TRANSLUCENT);
                brd.func_175018_a(state, key, (IBlockAccess)access, vb);
                ForgeHooksClient.setRenderLayer(null);
            }
            vb.func_181674_a((float)TileEntityRendererDispatcher.field_147554_b, (float)TileEntityRendererDispatcher.field_147555_c, (float)TileEntityRendererDispatcher.field_147552_d);
            tes.func_78381_a();
            GlStateManager.func_187415_K();
        }
    }

    public void updateLink(int linkDim, BlockPos linkPos) {
        this.hasOtherLink = true;
        this.otherLinkDim = linkDim;
        this.otherLinkPos = linkPos;
    }

    public void removeLink() {
        this.hasOtherLink = false;
        this.otherLinkDim = -1;
        this.otherLinkPos = BlockPos.field_177992_a;
    }

    public boolean hasOtherLink() {
        return this.hasOtherLink;
    }

    public BlockPos getOtherLinkPos() {
        return this.otherLinkPos;
    }

    public int getOtherLinkDim() {
        return this.otherLinkDim;
    }

    @SideOnly(value=Side.CLIENT)
    public void cleanUp() {
        if (this.clientBatchIdNormal != -1) {
            GlStateManager.func_187449_e((int)this.clientBatchIdNormal, (int)1);
            this.clientBatchIdNormal = -1;
            GlStateManager.func_187449_e((int)this.clientBatchIdTransparent, (int)1);
            this.clientBatchIdTransparent = -1;
        }
    }

    public void writeToNBT(NBTTagCompound compound) {
        NBTTagList listOffsets = new NBTTagList();
        for (Map.Entry<BlockPos, IBlockState> entry : this.stateOffsetMap.entrySet()) {
            NBTTagCompound tagEntry = new NBTTagCompound();
            tagEntry.func_74768_a("x", entry.getKey().func_177958_n());
            tagEntry.func_74768_a("y", entry.getKey().func_177956_o());
            tagEntry.func_74768_a("z", entry.getKey().func_177952_p());
            tagEntry.func_74768_a("state", Block.func_176210_f((IBlockState)entry.getValue()));
            listOffsets.func_74742_a((NBTBase)tagEntry);
        }
        compound.func_74782_a("list", (NBTBase)listOffsets);
        compound.func_74757_a("hasOtherLink", this.hasOtherLink);
        compound.func_74768_a("otherLinkDim", this.otherLinkDim);
        compound.func_74768_a("otherLinkPosX", this.otherLinkPos.func_177958_n());
        compound.func_74768_a("otherLinkPosY", this.otherLinkPos.func_177956_o());
        compound.func_74768_a("otherLinkPosZ", this.otherLinkPos.func_177952_p());
    }

    public static FissureData readFromNBT(NBTTagCompound compound) {
        FissureData data = new FissureData();
        NBTTagList list = compound.func_150295_c("list", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tagEntry = list.func_150305_b(i);
            BlockPos offset = new BlockPos(tagEntry.func_74762_e("x"), tagEntry.func_74762_e("y"), tagEntry.func_74762_e("z"));
            IBlockState state = Block.func_176220_d((int)tagEntry.func_74762_e("state"));
            data.stateOffsetMap.put(offset, state);
        }
        data.hasOtherLink = compound.func_74767_n("hasOtherLink");
        data.otherLinkDim = compound.func_74762_e("otherLinkDim");
        data.otherLinkPos = new BlockPos(compound.func_74762_e("otherLinkPosX"), compound.func_74762_e("otherLinkPosY"), compound.func_74762_e("otherLinkPosZ"));
        return data;
    }

    public boolean containsEqualBlocks(Map<BlockPos, IBlockState> other) {
        if (this.stateOffsetMap.size() != other.size()) {
            return false;
        }
        for (Map.Entry<BlockPos, IBlockState> otherEntry : other.entrySet()) {
            if (this.stateOffsetMap.containsKey(otherEntry.getKey()) && this.stateOffsetMap.get(otherEntry.getKey()).equals(otherEntry.getValue())) continue;
            return false;
        }
        return true;
    }
}

