/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.fracture.common.fissure;

import hellfirepvp.fracture.client.effect.block.TranslucentFissureFX;
import hellfirepvp.fracture.client.util.chunk.WatchedChunkCache;
import hellfirepvp.fracture.common.fissure.FissureData;
import hellfirepvp.fracture.common.fissure.FissureDataController;
import hellfirepvp.fracture.common.tile.TileFissureDevice;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class ClientFissureWorldHandler {
    private static Map<Integer, Map<BlockPos, FissureData>> activeFissures = new HashMap<Integer, Map<BlockPos, FissureData>>();

    public static void clientClean() {
        activeFissures.clear();
    }

    public static Map<BlockPos, List<IBlockState>> getNearFissureBlocks(World world, AxisAlignedBB box) {
        int minX = MathHelper.func_76128_c((double)(box.field_72340_a - 1.5));
        int minY = MathHelper.func_76128_c((double)(box.field_72338_b - 1.5));
        int minZ = MathHelper.func_76128_c((double)(box.field_72339_c - 1.5));
        int maxX = MathHelper.func_76143_f((double)(box.field_72336_d + 1.5));
        int maxY = MathHelper.func_76143_f((double)(box.field_72337_e + 1.5));
        int maxZ = MathHelper.func_76143_f((double)(box.field_72334_f + 1.5));
        BlockPos min = new BlockPos(minX, minY, minZ);
        BlockPos max = new BlockPos(maxX, maxY, maxZ);
        Map fissures = activeFissures.computeIfAbsent(world.field_73011_w.getDimension(), dimId -> new HashMap());
        HashMap<BlockPos, List<IBlockState>> out = new HashMap<BlockPos, List<IBlockState>>();
        for (Map.Entry fissure : fissures.entrySet()) {
            if (!((FissureData)fissure.getValue()).isInRange(min, (BlockPos)fissure.getKey()) && !((FissureData)fissure.getValue()).isInRange(max, (BlockPos)fissure.getKey())) continue;
            Map<BlockPos, IBlockState> stateMap = ((FissureData)fissure.getValue()).getStateOffsetMap();
            for (BlockPos pos : BlockPos.func_177980_a((BlockPos)min, (BlockPos)max)) {
                IBlockState offsetState = stateMap.get(pos.func_177973_b((Vec3i)fissure.getKey()));
                if (offsetState == null) continue;
                out.computeIfAbsent(pos, ignored -> new LinkedList()).add(offsetState);
            }
        }
        return out;
    }

    public static boolean activate(TileFissureDevice device) {
        World clientWorld = device.func_145831_w();
        int dim = clientWorld.field_73011_w.getDimension();
        BlockPos offset = device.func_174877_v();
        Map fissures = activeFissures.computeIfAbsent(dim, dimId -> new HashMap());
        if (fissures.containsKey(offset)) {
            return false;
        }
        FissureData ownFissureData = FissureDataController.getFissureData(clientWorld.field_73011_w.getDimension(), offset);
        if (ownFissureData == null || !ownFissureData.hasOtherLink()) {
            return false;
        }
        FissureData clientLinkedFissureData = FissureDataController.getFissureData(ownFissureData.getOtherLinkDim(), ownFissureData.getOtherLinkPos());
        if (clientLinkedFissureData == null) {
            return false;
        }
        fissures.put(offset, clientLinkedFissureData);
        WatchedChunkCache.setupReplacements(dim, offset, clientLinkedFissureData);
        TranslucentFissureFX.addEffect(dim, offset, ownFissureData, clientLinkedFissureData);
        if (Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension() == dim) {
            BlockPos min = clientLinkedFissureData.getMin().func_177971_a((Vec3i)offset);
            BlockPos max = clientLinkedFissureData.getMax().func_177971_a((Vec3i)offset);
            Minecraft.func_71410_x().field_71438_f.func_147585_a(min.func_177958_n(), min.func_177956_o(), min.func_177952_p(), max.func_177958_n(), max.func_177956_o(), max.func_177952_p());
        }
        return true;
    }

    public static void deactivate(TileFissureDevice device) {
        int dim = device.func_145831_w().field_73011_w.getDimension();
        BlockPos offset = device.func_174877_v();
        Map fissures = activeFissures.computeIfAbsent(dim, dimId -> new HashMap());
        if (fissures.containsKey(offset)) {
            FissureData fissure = (FissureData)fissures.get(offset);
            WatchedChunkCache.removeReplacements(dim, offset, fissure);
            fissures.remove(offset);
            if (Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension() == dim) {
                BlockPos min = fissure.getMin().func_177971_a((Vec3i)offset);
                BlockPos max = fissure.getMax().func_177971_a((Vec3i)offset);
                Minecraft.func_71410_x().field_71438_f.func_147585_a(min.func_177958_n(), min.func_177956_o(), min.func_177952_p(), max.func_177958_n(), max.func_177956_o(), max.func_177952_p());
            }
        }
        TranslucentFissureFX.removeEffect(dim, offset);
    }
}

