/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.fracture.common.data;

import hellfirepvp.fracture.common.data.AbstractData;
import hellfirepvp.fracture.common.fissure.FissureData;
import hellfirepvp.fracture.common.fissure.FissureDataController;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DataFissures
extends AbstractData {
    private Map<Integer, Map<BlockPos, FissureData>> updateRequested = new HashMap<Integer, Map<BlockPos, FissureData>>();
    private Map<Integer, List<BlockPos>> removalRequested = new HashMap<Integer, List<BlockPos>>();
    private Map<Integer, Map<BlockPos, FissureData>> clientUpdateRequested = new HashMap<Integer, Map<BlockPos, FissureData>>();
    private Map<Integer, List<BlockPos>> clientRemovalRequested = new HashMap<Integer, List<BlockPos>>();

    public void updateFissure(int dimension, BlockPos offset, FissureData data) {
        this.updateRequested.computeIfAbsent(dimension, dim -> new HashMap()).put(offset, data);
        if (this.removalRequested.computeIfAbsent(dimension, dim -> new LinkedList()).contains(offset)) {
            this.removalRequested.get(dimension).remove(offset);
        }
        this.markDirty();
    }

    public void removeFissure(int dimension, BlockPos offset) {
        this.removalRequested.computeIfAbsent(dimension, dim -> new LinkedList()).add(offset);
        Map dimFissures = this.updateRequested.computeIfAbsent(dimension, dim -> new HashMap());
        if (dimFissures.containsKey(offset)) {
            dimFissures.remove(offset);
        }
        this.markDirty();
    }

    @SideOnly(value=Side.CLIENT)
    private void updateClientFissureData(int dimension, BlockPos pos, FissureData data) {
        FissureDataController.addFissureClient(dimension, pos, data);
    }

    @SideOnly(value=Side.CLIENT)
    private void removeClientFissureData(int dimension, BlockPos pos) {
        FissureDataController.removeFissureClient(dimension, pos);
    }

    @Override
    public void writeAllDataToPacket(NBTTagCompound compound) {
        Map<Integer, Map<BlockPos, FissureData>> fissures = FissureDataController.getFissures();
        NBTTagList dimFissures = new NBTTagList();
        for (int dim : fissures.keySet()) {
            NBTTagCompound dimFissure = new NBTTagCompound();
            dimFissure.func_74768_a("dim", dim);
            NBTTagList listFissures = new NBTTagList();
            for (Map.Entry<BlockPos, FissureData> fissure : fissures.get(dim).entrySet()) {
                NBTTagCompound cmp = new NBTTagCompound();
                cmp.func_74768_a("x", fissure.getKey().func_177958_n());
                cmp.func_74768_a("y", fissure.getKey().func_177956_o());
                cmp.func_74768_a("z", fissure.getKey().func_177952_p());
                NBTTagCompound tagFissure = new NBTTagCompound();
                fissure.getValue().writeToNBT(tagFissure);
                cmp.func_74782_a("fissure", (NBTBase)tagFissure);
                listFissures.func_74742_a((NBTBase)cmp);
            }
            dimFissure.func_74782_a("list", (NBTBase)listFissures);
            dimFissures.func_74742_a((NBTBase)dimFissure);
        }
        compound.func_74782_a("update", (NBTBase)dimFissures);
        compound.func_74782_a("remove", (NBTBase)new NBTTagList());
    }

    @Override
    public void writeToPacket(NBTTagCompound compound) {
        NBTTagList dimFissures = new NBTTagList();
        for (int dim : this.updateRequested.keySet()) {
            NBTTagCompound dimFissure = new NBTTagCompound();
            dimFissure.func_74768_a("dim", dim);
            NBTTagList listFissures = new NBTTagList();
            for (Map.Entry<BlockPos, FissureData> fissure : this.updateRequested.get(dim).entrySet()) {
                NBTTagCompound cmp = new NBTTagCompound();
                cmp.func_74768_a("x", fissure.getKey().func_177958_n());
                cmp.func_74768_a("y", fissure.getKey().func_177956_o());
                cmp.func_74768_a("z", fissure.getKey().func_177952_p());
                NBTTagCompound tagFissure = new NBTTagCompound();
                fissure.getValue().writeToNBT(tagFissure);
                cmp.func_74782_a("fissure", (NBTBase)tagFissure);
                listFissures.func_74742_a((NBTBase)cmp);
            }
            dimFissure.func_74782_a("list", (NBTBase)listFissures);
            dimFissures.func_74742_a((NBTBase)dimFissure);
        }
        compound.func_74782_a("update", (NBTBase)dimFissures);
        NBTTagList listRemovals = new NBTTagList();
        for (int dim : this.removalRequested.keySet()) {
            NBTTagCompound dimRemove = new NBTTagCompound();
            dimRemove.func_74768_a("dim", dim);
            NBTTagList listRemove = new NBTTagList();
            for (BlockPos remove : this.removalRequested.get(dim)) {
                NBTTagCompound tagRemove = new NBTTagCompound();
                tagRemove.func_74768_a("x", remove.func_177958_n());
                tagRemove.func_74768_a("y", remove.func_177956_o());
                tagRemove.func_74768_a("z", remove.func_177952_p());
                listRemove.func_74742_a((NBTBase)tagRemove);
            }
            dimRemove.func_74782_a("list", (NBTBase)listRemove);
            listRemovals.func_74742_a((NBTBase)dimRemove);
        }
        compound.func_74782_a("remove", (NBTBase)listRemovals);
        this.updateRequested.clear();
        this.removalRequested.clear();
    }

    @Override
    public void readRawFromPacket(NBTTagCompound compound) {
        NBTTagList listUpdate = compound.func_150295_c("update", 10);
        for (int i = 0; i < listUpdate.func_74745_c(); ++i) {
            NBTTagCompound dimFissure = listUpdate.func_150305_b(i);
            int dim = dimFissure.func_74762_e("dim");
            HashMap<BlockPos, FissureData> fissures = new HashMap<BlockPos, FissureData>();
            this.clientUpdateRequested.put(dim, fissures);
            NBTTagList listFissures = dimFissure.func_150295_c("list", 10);
            for (int j = 0; j < listFissures.func_74745_c(); ++j) {
                NBTTagCompound tagFissure = listFissures.func_150305_b(j);
                BlockPos pos = new BlockPos(tagFissure.func_74762_e("x"), tagFissure.func_74762_e("y"), tagFissure.func_74762_e("z"));
                NBTTagCompound tagFissureData = tagFissure.func_74775_l("fissure");
                FissureData data = FissureData.readFromNBT(tagFissureData);
                fissures.put(pos, data);
            }
        }
        NBTTagList listRemoval = compound.func_150295_c("remove", 10);
        for (int i = 0; i < listRemoval.func_74745_c(); ++i) {
            NBTTagCompound dimRemove = listRemoval.func_150305_b(i);
            int dim = dimRemove.func_74762_e("dim");
            LinkedList<BlockPos> removals = new LinkedList<BlockPos>();
            this.clientRemovalRequested.put(dim, removals);
            NBTTagList listRemovals = dimRemove.func_150295_c("list", 10);
            for (int j = 0; j < listRemovals.func_74745_c(); ++j) {
                NBTTagCompound tagRemove = listRemovals.func_150305_b(j);
                BlockPos pos = new BlockPos(tagRemove.func_74762_e("x"), tagRemove.func_74762_e("y"), tagRemove.func_74762_e("z"));
                removals.add(pos);
            }
        }
    }

    @Override
    public void handleIncomingData(AbstractData serverData) {
        ((DataFissures)serverData).clientUpdateRequested.entrySet().forEach(entry -> ((Map)entry.getValue()).entrySet().forEach(entryOffset -> this.updateClientFissureData((Integer)entry.getKey(), (BlockPos)entryOffset.getKey(), (FissureData)entryOffset.getValue())));
        ((DataFissures)serverData).clientRemovalRequested.entrySet().forEach(entry -> ((List)entry.getValue()).forEach(entryRemove -> this.removeClientFissureData((Integer)entry.getKey(), (BlockPos)entryRemove)));
        ((DataFissures)serverData).clientRemovalRequested.clear();
        ((DataFissures)serverData).clientUpdateRequested.clear();
    }

    @SideOnly(value=Side.CLIENT)
    public void cleanUp() {
        this.clientRemovalRequested.clear();
        this.clientUpdateRequested.clear();
    }

    public static class Provider
    extends AbstractData.ProviderAutoAllocate<DataFissures> {
        public Provider(String key) {
            super(key);
        }

        @Override
        public DataFissures provideNewInstance() {
            return new DataFissures();
        }
    }
}

