/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.fracture.client.util.chunk;

import hellfirepvp.fracture.common.fissure.FissureData;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.World;

public class WatchedChunkCache
extends ChunkCache {
    private static Map<Integer, Map<BlockPos, Deque<IBlockState>>> replacements = new HashMap<Integer, Map<BlockPos, Deque<IBlockState>>>();

    public WatchedChunkCache(World worldIn, BlockPos posFromIn, BlockPos posToIn, int subIn) {
        super(worldIn, posFromIn, posToIn, subIn);
    }

    public IBlockState func_180495_p(BlockPos pos) {
        IBlockState replacement = WatchedChunkCache.searchForState(this.field_72815_e, pos);
        return replacement != null ? replacement : super.func_180495_p(pos);
    }

    public static void setupReplacements(int dimension, BlockPos offset, FissureData data) {
        Map states = replacements.computeIfAbsent(dimension, dim -> new HashMap());
        Map<BlockPos, IBlockState> fissureStates = data.getStateOffsetMap();
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)data.getMin().func_177971_a((Vec3i)offset), (BlockPos)data.getMax().func_177971_a((Vec3i)offset))) {
            if (pos.equals((Object)offset)) continue;
            Deque replaceStates = states.computeIfAbsent(pos, ignored -> new LinkedList());
            IBlockState replacement = fissureStates.containsKey(pos.func_177973_b((Vec3i)offset)) ? fissureStates.get(pos.func_177973_b((Vec3i)offset)) : Blocks.field_150350_a.func_176223_P();
            replaceStates.addLast(replacement);
        }
    }

    public static void removeReplacements(int dimension, BlockPos offset, FissureData data) {
        Map states = replacements.computeIfAbsent(dimension, dim -> new HashMap());
        Map<BlockPos, IBlockState> fissureStates = data.getStateOffsetMap();
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)data.getMin().func_177971_a((Vec3i)offset), (BlockPos)data.getMax().func_177971_a((Vec3i)offset))) {
            IBlockState removable;
            Deque applicable;
            if (pos.equals((Object)offset) || !states.containsKey(pos) || !(applicable = (Deque)states.get(pos)).remove(removable = fissureStates.containsKey(pos.func_177973_b((Vec3i)offset)) ? fissureStates.get(pos.func_177973_b((Vec3i)offset)) : Blocks.field_150350_a.func_176223_P()) || !applicable.isEmpty()) continue;
            states.remove(pos);
        }
    }

    @Nullable
    private static IBlockState searchForState(World world, BlockPos pos) {
        int dim = world.field_73011_w.getDimension();
        Map<BlockPos, Deque<IBlockState>> worldReplacements = replacements.get(dim);
        if (worldReplacements != null && worldReplacements.containsKey(pos)) {
            return worldReplacements.get(pos).getFirst();
        }
        return null;
    }

    public static void cleanUp() {
        replacements.clear();
    }
}

