/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.fracture.client.util;

import hellfirepvp.fracture.common.util.Vector3;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;

public class RenderingUtils {
    public static void sortVertexData(BufferBuilder vb) {
        vb.func_181674_a((float)TileEntityRendererDispatcher.field_147554_b, (float)TileEntityRendererDispatcher.field_147555_c, (float)TileEntityRendererDispatcher.field_147552_d);
    }

    public static Color clampToColor(int rgb) {
        return RenderingUtils.clampToColorWithMultiplier(rgb, 1.0f);
    }

    public static Color clampToColorWithMultiplier(int rgb, float mul) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb >> 0 & 0xFF;
        return new Color(MathHelper.func_76125_a((int)((int)((float)r * mul)), (int)0, (int)255), MathHelper.func_76125_a((int)((int)((float)g * mul)), (int)0, (int)255), MathHelper.func_76125_a((int)((int)((float)b * mul)), (int)0, (int)255));
    }

    public static Color clampToColor(int r, int g, int b) {
        return new Color(MathHelper.func_76125_a((int)((int)((float)r)), (int)0, (int)255), MathHelper.func_76125_a((int)((int)((float)g)), (int)0, (int)255), MathHelper.func_76125_a((int)((int)((float)b)), (int)0, (int)255));
    }

    public static Vector3 interpolatePosition(Entity e, float partialTicks) {
        return new Vector3(RenderingUtils.interpolate(e.field_70142_S, e.field_70165_t, partialTicks), RenderingUtils.interpolate(e.field_70137_T, e.field_70163_u, partialTicks), RenderingUtils.interpolate(e.field_70136_U, e.field_70161_v, partialTicks));
    }

    public static double interpolate(double oldP, double newP, float partialTicks) {
        if (oldP == newP) {
            return oldP;
        }
        return oldP + (newP - oldP) * (double)partialTicks;
    }

    public static Vector3 interpolateVec(Vector3 oldVec, Vector3 newVec, float partialTicks) {
        return new Vector3(RenderingUtils.interpolate(oldVec.getX(), newVec.getX(), partialTicks), RenderingUtils.interpolate(oldVec.getY(), newVec.getY(), partialTicks), RenderingUtils.interpolate(oldVec.getZ(), newVec.getZ(), partialTicks));
    }

    public static float interpolateRotation(float prevRotation, float nextRotation, float partialTick) {
        float rot;
        for (rot = nextRotation - prevRotation; rot >= 180.0f; rot -= 360.0f) {
        }
        while (rot >= 180.0f) {
            rot -= 360.0f;
        }
        return prevRotation + partialTick * rot;
    }

    public static void removeStandartTranslationFromTESRMatrix(float partialTicks) {
        Entity rView = Minecraft.func_71410_x().func_175606_aa();
        if (rView == null) {
            rView = Minecraft.func_71410_x().field_71439_g;
        }
        Entity entity = rView;
        double tx = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
        double ty = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
        double tz = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
        GlStateManager.func_179137_b((double)(-tx), (double)(-ty), (double)(-tz));
    }

    public static Vector3 getStandartTranslationRemovalVector(float partialTicks) {
        Entity rView = Minecraft.func_71410_x().func_175606_aa();
        if (rView == null) {
            rView = Minecraft.func_71410_x().field_71439_g;
        }
        Entity entity = rView;
        double tx = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
        double ty = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
        double tz = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
        return new Vector3(-tx, -ty, -tz);
    }

    public static void renderTexturedCubeCentral(Vector3 offset, double size, double u, double v, double uLength, double vLength) {
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        double half = size / 2.0;
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b(offset.getX() - half, offset.getY() - half, offset.getZ() - half).func_187315_a(u, v).func_181675_d();
        vb.func_181662_b(offset.getX() + half, offset.getY() - half, offset.getZ() - half).func_187315_a(u + uLength, v).func_181675_d();
        vb.func_181662_b(offset.getX() + half, offset.getY() - half, offset.getZ() + half).func_187315_a(u + uLength, v + vLength).func_181675_d();
        vb.func_181662_b(offset.getX() - half, offset.getY() - half, offset.getZ() + half).func_187315_a(u, v + vLength).func_181675_d();
        vb.func_181662_b(offset.getX() - half, offset.getY() + half, offset.getZ() + half).func_187315_a(u, v).func_181675_d();
        vb.func_181662_b(offset.getX() + half, offset.getY() + half, offset.getZ() + half).func_187315_a(u + uLength, v).func_181675_d();
        vb.func_181662_b(offset.getX() + half, offset.getY() + half, offset.getZ() - half).func_187315_a(u + uLength, v + vLength).func_181675_d();
        vb.func_181662_b(offset.getX() - half, offset.getY() + half, offset.getZ() - half).func_187315_a(u, v + vLength).func_181675_d();
        vb.func_181662_b(offset.getX() - half, offset.getY() - half, offset.getZ() + half).func_187315_a(u + uLength, v).func_181675_d();
        vb.func_181662_b(offset.getX() - half, offset.getY() + half, offset.getZ() + half).func_187315_a(u + uLength, v + vLength).func_181675_d();
        vb.func_181662_b(offset.getX() - half, offset.getY() + half, offset.getZ() - half).func_187315_a(u, v + vLength).func_181675_d();
        vb.func_181662_b(offset.getX() - half, offset.getY() - half, offset.getZ() - half).func_187315_a(u, v).func_181675_d();
        vb.func_181662_b(offset.getX() + half, offset.getY() - half, offset.getZ() - half).func_187315_a(u + uLength, v).func_181675_d();
        vb.func_181662_b(offset.getX() + half, offset.getY() + half, offset.getZ() - half).func_187315_a(u + uLength, v + vLength).func_181675_d();
        vb.func_181662_b(offset.getX() + half, offset.getY() + half, offset.getZ() + half).func_187315_a(u, v + vLength).func_181675_d();
        vb.func_181662_b(offset.getX() + half, offset.getY() - half, offset.getZ() + half).func_187315_a(u, v).func_181675_d();
        vb.func_181662_b(offset.getX() + half, offset.getY() - half, offset.getZ() - half).func_187315_a(u, v).func_181675_d();
        vb.func_181662_b(offset.getX() + half, offset.getY() + half, offset.getZ() - half).func_187315_a(u, v + vLength).func_181675_d();
        vb.func_181662_b(offset.getX() - half, offset.getY() + half, offset.getZ() - half).func_187315_a(u + uLength, v + vLength).func_181675_d();
        vb.func_181662_b(offset.getX() - half, offset.getY() - half, offset.getZ() - half).func_187315_a(u + uLength, v).func_181675_d();
        vb.func_181662_b(offset.getX() - half, offset.getY() - half, offset.getZ() + half).func_187315_a(u, v).func_181675_d();
        vb.func_181662_b(offset.getX() - half, offset.getY() + half, offset.getZ() + half).func_187315_a(u, v + vLength).func_181675_d();
        vb.func_181662_b(offset.getX() + half, offset.getY() + half, offset.getZ() + half).func_187315_a(u + uLength, v + vLength).func_181675_d();
        vb.func_181662_b(offset.getX() + half, offset.getY() - half, offset.getZ() + half).func_187315_a(u + uLength, v).func_181675_d();
        tes.func_78381_a();
    }

    public static void renderFacingFullQuadVB(BufferBuilder vb, double px, double py, double pz, float partialTicks, float scale, float angle, float colorRed, float colorGreen, float colorBlue, float alpha) {
        RenderingUtils.renderFacingQuadVB(vb, px, py, pz, partialTicks, scale, angle, 0.0, 0.0, 1.0, 1.0, colorRed, colorGreen, colorBlue, alpha);
    }

    public static void renderFacingQuadVB(BufferBuilder vb, double px, double py, double pz, float partialTicks, float scale, float angle, double u, double v, double uLength, double vLength, float colorRed, float colorGreen, float colorBlue, float alpha) {
        float arX = ActiveRenderInfo.func_178808_b();
        float arZ = ActiveRenderInfo.func_178803_d();
        float arYZ = ActiveRenderInfo.func_178805_e();
        float arXY = ActiveRenderInfo.func_178807_f();
        float arXZ = ActiveRenderInfo.func_178809_c();
        Entity e = Minecraft.func_71410_x().func_175606_aa();
        if (e == null) {
            e = Minecraft.func_71410_x().field_71439_g;
        }
        double iPX = e.field_70169_q + (e.field_70165_t - e.field_70169_q) * (double)partialTicks;
        double iPY = e.field_70167_r + (e.field_70163_u - e.field_70167_r) * (double)partialTicks;
        double iPZ = e.field_70166_s + (e.field_70161_v - e.field_70166_s) * (double)partialTicks;
        Vector3 v1 = new Vector3(-arX * scale - arYZ * scale, -arXZ * scale, -arZ * scale - arXY * scale);
        Vector3 v2 = new Vector3(-arX * scale + arYZ * scale, arXZ * scale, -arZ * scale + arXY * scale);
        Vector3 v3 = new Vector3(arX * scale + arYZ * scale, arXZ * scale, arZ * scale + arXY * scale);
        Vector3 v4 = new Vector3(arX * scale - arYZ * scale, -arXZ * scale, arZ * scale - arXY * scale);
        if (angle != 0.0f) {
            Vector3 pvec = new Vector3(iPX, iPY, iPZ);
            Vector3 tvec = new Vector3(px, py, pz);
            Vector3 qvec = pvec.subtract(tvec).normalize();
            Vector3.Quat q = Vector3.Quat.buildQuatFrom3DVector(qvec, angle);
            q.rotateWithMagnitude(v1);
            q.rotateWithMagnitude(v2);
            q.rotateWithMagnitude(v3);
            q.rotateWithMagnitude(v4);
        }
        vb.func_181662_b(px + v1.getX() - iPX, py + v1.getY() - iPY, pz + v1.getZ() - iPZ).func_187315_a(u + uLength, v + vLength).func_181666_a(colorRed, colorGreen, colorBlue, alpha).func_181675_d();
        vb.func_181662_b(px + v2.getX() - iPX, py + v2.getY() - iPY, pz + v2.getZ() - iPZ).func_187315_a(u + uLength, v).func_181666_a(colorRed, colorGreen, colorBlue, alpha).func_181675_d();
        vb.func_181662_b(px + v3.getX() - iPX, py + v3.getY() - iPY, pz + v3.getZ() - iPZ).func_187315_a(u, v).func_181666_a(colorRed, colorGreen, colorBlue, alpha).func_181675_d();
        vb.func_181662_b(px + v4.getX() - iPX, py + v4.getY() - iPY, pz + v4.getZ() - iPZ).func_187315_a(u, v + vLength).func_181666_a(colorRed, colorGreen, colorBlue, alpha).func_181675_d();
    }
}

