/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.fracture.client.texture;

import hellfirepvp.fracture.Fracture;
import hellfirepvp.fracture.client.texture.AssetLibrary;
import hellfirepvp.fracture.client.texture.SpriteSheetResource;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class BindableResource {
    private ITextureObject resource = null;
    private String path;

    public BindableResource(String path) {
        this.path = path;
        this.allocateGlId();
    }

    public String getPath() {
        return this.path;
    }

    public boolean isInitialized() {
        return this.resource != null;
    }

    public ITextureObject getResource() {
        return this.resource;
    }

    public SpriteSheetResource asSpriteSheet(int rows, int columns) {
        return new SpriteSheetResource(this, rows, columns);
    }

    @Deprecated
    public void invalidateAndReload() {
        if (this.resource != null) {
            GL11.glDeleteTextures((int)this.resource.func_110552_b());
        }
        this.resource = null;
    }

    public void allocateGlId() {
        if (this.resource != null || AssetLibrary.reloading) {
            return;
        }
        this.resource = new SimpleTexture(new ResourceLocation(this.path));
        try {
            this.resource.func_110551_a(Minecraft.func_71410_x().func_110442_L());
        }
        catch (Exception exc) {
            Fracture.log.warn("[Fracture] [AssetLibrary] Failed to load texture " + this.path);
            Fracture.log.warn("[Fracture] [AssetLibrary] Please report this issue; include the message above, the following stacktrace as well as instructions on how to reproduce this!");
            exc.printStackTrace();
            this.resource = TextureUtil.field_111001_a;
        }
    }

    public void bind() {
        if (AssetLibrary.reloading) {
            return;
        }
        if (this.resource == null) {
            this.allocateGlId();
        }
        GL11.glBindTexture((int)3553, (int)this.resource.func_110552_b());
    }
}

