/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.fracture.client.texture;

import hellfirepvp.fracture.client.texture.BindableResource;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AssetLoader {
    private AssetLoader() {
    }

    @SideOnly(value=Side.CLIENT)
    protected static BindableResource load(AssetLocation location, SubLocation subLocation, String name, String suffix) {
        return new BindableResource(AssetLoader.buildResourceString(location, subLocation, name, suffix));
    }

    @SideOnly(value=Side.CLIENT)
    private static String buildResourceString(AssetLocation location, SubLocation subLocation, String name, String suffix) {
        if (name.endsWith(suffix)) {
            name = name.substring(0, name.length() - suffix.length());
        }
        StringBuilder builder = new StringBuilder();
        builder.append("fracture").append(':').append(location.location).append("/");
        if (subLocation != null) {
            builder.append(subLocation.getLocation()).append("/");
        }
        builder.append(name).append(suffix);
        return builder.toString();
    }

    @SideOnly(value=Side.CLIENT)
    protected static BindableResource loadTexture(TextureLocation location, String name) {
        return AssetLoader.load(AssetLocation.TEXTURES, location, name, ".png");
    }

    public static enum AssetLocation {
        TEXTURES("textures");

        private final String location;

        private AssetLocation(String location) {
            this.location = location;
        }
    }

    public static enum TextureLocation implements SubLocation
    {
        BLOCKS("blocks"),
        EFFECT("effect");

        private final String location;

        private TextureLocation(String location) {
            this.location = location;
        }

        @Override
        public String getLocation() {
            return this.location;
        }
    }

    public static interface SubLocation {
        public String getLocation();
    }
}

