/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.fracture.client.texture;

import hellfirepvp.fracture.Fracture;
import hellfirepvp.fracture.client.texture.AssetLoader;
import hellfirepvp.fracture.client.texture.BindableResource;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;

public class AssetLibrary
implements IResourceManagerReloadListener {
    public static AssetLibrary resReloadInstance = new AssetLibrary();
    public static boolean reloading = false;
    private static Map<AssetLoader.SubLocation, Map<String, BindableResource>> loadedTextures = new HashMap<AssetLoader.SubLocation, Map<String, BindableResource>>();

    private AssetLibrary() {
    }

    public static BindableResource loadTexture(AssetLoader.TextureLocation location, String name) {
        Map<String, BindableResource> resources;
        if (name.endsWith(".png")) {
            throw new IllegalArgumentException("Tried to loadTexture with appended .png from the AssetLibrary!");
        }
        if (!loadedTextures.containsKey(location)) {
            loadedTextures.put(location, new HashMap());
        }
        if ((resources = loadedTextures.get(location)).containsKey(name)) {
            return resources.get(name);
        }
        BindableResource res = AssetLoader.load(AssetLoader.AssetLocation.TEXTURES, location, name, ".png");
        resources.put(name, res);
        return res;
    }

    public void func_110549_a(@Nullable IResourceManager resourceManager) {
        if (reloading) {
            return;
        }
        reloading = true;
        Fracture.log.info("[Fracture] [AssetLibrary] Refreshing and Invalidating Resources");
        for (Map<String, BindableResource> map : loadedTextures.values()) {
            for (BindableResource res : map.values()) {
                res.invalidateAndReload();
            }
        }
        reloading = false;
        Fracture.log.info("[Fracture] [AssetLibrary] Successfully reloaded and rebound library.");
    }
}

