/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.fracture.client.effect.fx;

import hellfirepvp.fracture.client.effect.EntityFX;
import hellfirepvp.fracture.client.texture.BindableResource;
import hellfirepvp.fracture.client.util.Blending;
import hellfirepvp.fracture.client.util.RenderingUtils;
import hellfirepvp.fracture.client.util.TextureHelper;
import hellfirepvp.fracture.common.util.Vector3;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.opengl.GL11;

public class EntityFXFloatingCube
extends EntityFX {
    private Vector3 rotationDegreeAxis = new Vector3();
    private Vector3 prevRotationDegreeAxis = new Vector3();
    private Vector3 rotationChange = new Vector3();
    private float tumbleIntensityMultiplier = 0.0f;
    private final BindableResource texture;

    public EntityFXFloatingCube(int maxAge, BindableResource texture) {
        super(maxAge);
        this.texture = texture;
    }

    @Override
    public int getLayer() {
        return 1;
    }

    public Vector3 getInterpolatedPosition(float percent) {
        return RenderingUtils.interpolateVec(this.prevPos, this.pos, percent);
    }

    public Vector3 getInterpolatedRotation(float percent) {
        return new Vector3(RenderingUtils.interpolate(this.prevRotationDegreeAxis.getX(), this.rotationDegreeAxis.getX(), percent), RenderingUtils.interpolate(this.prevRotationDegreeAxis.getY(), this.rotationDegreeAxis.getY(), percent), RenderingUtils.interpolate(this.prevRotationDegreeAxis.getZ(), this.rotationDegreeAxis.getZ(), percent));
    }

    public void setTumbleIntensityMultiplier(float tumbleIntensityMultiplier) {
        this.tumbleIntensityMultiplier = tumbleIntensityMultiplier;
    }

    public EntityFXFloatingCube tumble() {
        this.rotationDegreeAxis = Vector3.positiveYRandom().multiply(360);
        this.rotationChange = Vector3.random().multiply(8);
        return this;
    }

    public void setRotationDegreeAxis(Vector3 rotationDegreeAxis) {
        this.rotationDegreeAxis = rotationDegreeAxis;
    }

    public void setPrevRotationDegreeAxis(Vector3 prevRotationDegreeAxis) {
        this.prevRotationDegreeAxis = prevRotationDegreeAxis;
    }

    public Vector3 getRotationDegreeAxis() {
        return this.rotationDegreeAxis;
    }

    public Vector3 getPrevRotationDegreeAxis() {
        return this.prevRotationDegreeAxis;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.tumbleIntensityMultiplier > 0.0f && this.rotationChange.lengthSquared() > 0.0) {
            Vector3 degAxis = this.rotationDegreeAxis.clone();
            Vector3 modify = this.rotationChange.clone().multiply(this.tumbleIntensityMultiplier);
            this.prevRotationDegreeAxis = this.rotationDegreeAxis.clone();
            this.rotationDegreeAxis.add(modify);
            Vector3 newDegAxis = this.rotationDegreeAxis;
            newDegAxis.setX(newDegAxis.getX() % 360.0).setY(newDegAxis.getY() % 360.0).setZ(newDegAxis.getZ() % 360.0);
            if (!degAxis.add(modify).equals(newDegAxis)) {
                this.prevRotationDegreeAxis = this.rotationDegreeAxis.clone().subtract(modify);
            }
        } else {
            this.prevRotationDegreeAxis = this.rotationDegreeAxis.clone();
        }
    }

    @Override
    public void render(float partialTicks) {
        TextureHelper.refreshTextureBindState();
        this.texture.bind();
        GlStateManager.func_179094_E();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        Blending.DEFAULT.apply();
        Blending.DEFAULT.applyStateManager();
        GlStateManager.func_179129_p();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179118_c();
        RenderingUtils.removeStandartTranslationFromTESRMatrix(partialTicks);
        Vector3 translateTo = this.getInterpolatedPosition(partialTicks);
        GL11.glTranslated((double)translateTo.getX(), (double)translateTo.getY(), (double)translateTo.getZ());
        float alpha = this.alphaFunction.getAlpha(this.age, this.maxAge);
        GlStateManager.func_179131_c((float)this.colorRed, (float)this.colorGreen, (float)this.colorBlue, (float)(alpha *= this.alphaMultiplier));
        float scaleF = this.scale;
        scaleF = this.scaleFunction.getScale(this, partialTicks, scaleF);
        GlStateManager.func_179152_a((float)scaleF, (float)scaleF, (float)scaleF);
        Vector3 rotation = this.getInterpolatedRotation(partialTicks);
        GlStateManager.func_179114_b((float)((float)rotation.getX()), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)rotation.getY()), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)rotation.getZ()), (float)0.0f, (float)0.0f, (float)1.0f);
        RenderingUtils.renderTexturedCubeCentral(new Vector3(), 1.0, 0.0, 0.0, 1.0, 1.0);
        GlStateManager.func_179141_d();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179089_o();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
        TextureHelper.refreshTextureBindState();
    }
}

