/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.fracture.client.effect.block;

import hellfirepvp.fracture.client.util.Blending;
import hellfirepvp.fracture.client.util.RenderingUtils;
import hellfirepvp.fracture.client.util.TextureHelper;
import hellfirepvp.fracture.client.util.WorldBlockArrayRenderAccess;
import hellfirepvp.fracture.common.data.Config;
import hellfirepvp.fracture.common.fissure.FissureData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockAir;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class TranslucentFissureFX {
    private static Map<Integer, Map<BlockPos, Tuple<FissureData, FissureData>>> activeFissureEffects = new HashMap<Integer, Map<BlockPos, Tuple<FissureData, FissureData>>>();
    private static int hash = -1;
    private static int batchDList = -1;

    public static void addEffect(int dim, BlockPos offset, FissureData ownFissure, FissureData replacementFissure) {
        Map dimData = activeFissureEffects.computeIfAbsent(dim, ignored -> new HashMap());
        dimData.put(offset, new Tuple((Object)ownFissure, (Object)replacementFissure));
    }

    public static void removeEffect(int dim, BlockPos offset) {
        Map dimData = activeFissureEffects.computeIfAbsent(dim, ignored -> new HashMap());
        dimData.remove(offset);
    }

    public static void cleanBatch() {
        activeFissureEffects.clear();
        if (batchDList != -1) {
            GLAllocation.func_74523_b((int)batchDList);
            batchDList = -1;
            hash = -1;
        }
    }

    public static void renderBatched(float pTicks) {
        if (Minecraft.func_71410_x().field_71441_e == null || Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        int dim = Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension();
        EntityPlayerSP center = Minecraft.func_71410_x().field_71439_g;
        BlockPos offset = center.func_180425_c();
        Map<BlockPos, Tuple<FissureData, FissureData>> fissures = TranslucentFissureFX.collectFissures(dim, offset);
        WorldBlockArrayRenderAccess iba = new WorldBlockArrayRenderAccess((IBlockAccess)Minecraft.func_71410_x().field_71441_e, null);
        for (Map.Entry<BlockPos, Tuple<FissureData, FissureData>> fissureData : fissures.entrySet()) {
            Map<BlockPos, IBlockState> offsetMap = ((FissureData)fissureData.getValue().func_76340_b()).getStateOffsetMap();
            for (Map.Entry<BlockPos, IBlockState> states : offsetMap.entrySet()) {
                iba.setOffsetBlockState(fissureData.getKey().func_177971_a((Vec3i)states.getKey()), states.getValue());
            }
        }
        TextureHelper.refreshTextureBindState();
        TextureHelper.setActiveTextureToAtlasSprite();
        GlStateManager.func_179094_E();
        RenderingUtils.removeStandartTranslationFromTESRMatrix(pTicks);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int hashFissures = TranslucentFissureFX.hashValue(fissures, iba);
        if (hash == -1 || batchDList == -1 || hash != hashFissures) {
            TranslucentFissureFX.batchRender(pTicks, fissures, iba);
            hash = hashFissures;
        }
        GlStateManager.func_179147_l();
        Blending.OVERLAYDARK.applyStateManager();
        Blending.OVERLAYDARK.apply();
        GlStateManager.func_179148_o((int)batchDList);
        Blending.DEFAULT.applyStateManager();
        Blending.DEFAULT.apply();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    private static void batchRender(float pTicks, Map<BlockPos, Tuple<FissureData, FissureData>> fissures, IBlockAccess iba) {
        BlockRendererDispatcher brd = Minecraft.func_71410_x().func_175602_ab();
        batchDList = GLAllocation.func_74526_a((int)1);
        GlStateManager.func_179147_l();
        Blending.OVERLAYDARK.applyStateManager();
        Blending.OVERLAYDARK.apply();
        GlStateManager.func_187423_f((int)batchDList, (int)4864);
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        ArrayList<BlockPos> rendered = new ArrayList<BlockPos>();
        for (Map.Entry<BlockPos, Tuple<FissureData, FissureData>> fissureData : fissures.entrySet()) {
            FissureData limiter = (FissureData)fissureData.getValue().func_76340_b();
            for (BlockPos offset : BlockPos.func_177980_a((BlockPos)limiter.getMin().func_177971_a((Vec3i)fissureData.getKey()), (BlockPos)limiter.getMax().func_177971_a((Vec3i)fissureData.getKey()))) {
                if (offset.equals((Object)fissureData.getKey())) continue;
                IBlockState real = Minecraft.func_71410_x().field_71441_e.func_180495_p(offset);
                IBlockState state = iba.func_180495_p(offset);
                if (real.func_177230_c() instanceof BlockAir) {
                    rendered.add(offset);
                    continue;
                }
                if (!(state.func_177230_c() instanceof BlockAir) || rendered.contains(offset)) continue;
                rendered.add(offset);
                try {
                    brd.func_175018_a(real, offset, (IBlockAccess)Minecraft.func_71410_x().field_71441_e, vb);
                }
                catch (Exception exception) {}
            }
        }
        vb.func_181674_a((float)TileEntityRendererDispatcher.field_147554_b, (float)TileEntityRendererDispatcher.field_147555_c, (float)TileEntityRendererDispatcher.field_147552_d);
        tes.func_78381_a();
        GlStateManager.func_187415_K();
        Blending.DEFAULT.applyStateManager();
        Blending.DEFAULT.apply();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static int hashValue(Map<BlockPos, Tuple<FissureData, FissureData>> fissures, IBlockAccess world) {
        int hash = 1727395782;
        for (Map.Entry<BlockPos, Tuple<FissureData, FissureData>> data : fissures.entrySet()) {
            hash ^= data.getKey().hashCode();
            hash ^= ((FissureData)data.getValue().func_76341_a()).getHash(data.getKey(), world) * 5517;
        }
        return hash;
    }

    private static Map<BlockPos, Tuple<FissureData, FissureData>> collectFissures(int dim, BlockPos offset) {
        double range = Config.maxEffectRenderDistanceSq;
        HashMap<BlockPos, Tuple<FissureData, FissureData>> collect = new HashMap<BlockPos, Tuple<FissureData, FissureData>>();
        Map dimData = activeFissureEffects.computeIfAbsent(dim, ignored -> new HashMap());
        for (Map.Entry fissures : dimData.entrySet()) {
            if (!(((BlockPos)fissures.getKey()).func_177951_i((Vec3i)offset) <= range)) continue;
            collect.put((BlockPos)fissures.getKey(), (Tuple<FissureData, FissureData>)fissures.getValue());
        }
        return collect;
    }
}

