/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.fracture.client.effect;

import hellfirepvp.fracture.client.util.RenderingUtils;
import hellfirepvp.fracture.common.util.Vector3;
import java.awt.Color;

public abstract class EntityFX {
    protected Vector3 pos = new Vector3();
    protected Vector3 prevPos = new Vector3();
    protected Vector3 motion = new Vector3();
    protected PositionController<EntityFX> positionController = (fx, position, motionToBeMoved) -> position.add(motionToBeMoved);
    protected ScaleFunction<EntityFX> scaleFunction = (fx, pTicks, scaleIn) -> scaleIn;
    protected RefreshFunction refreshFunction = () -> false;
    protected AlphaFunction alphaFunction = AlphaFunction.CONSTANT;
    protected float alphaMultiplier = 1.0f;
    protected int age = 0;
    protected int maxAge;
    protected float scale = 1.0f;
    protected float gravityMultiplier = 1.0f;
    protected float colorRed = 1.0f;
    protected float colorGreen = 1.0f;
    protected float colorBlue = 1.0f;
    protected boolean removeRequested = false;
    protected boolean flagRemoved = false;

    public EntityFX(int maxAge) {
        this.maxAge = maxAge;
    }

    public abstract void render(float var1);

    public void setAlphaFunction(AlphaFunction alphaFunction) {
        this.alphaFunction = alphaFunction;
    }

    public AlphaFunction getAlphaFunction() {
        return this.alphaFunction;
    }

    public void setPosition(Vector3 pos) {
        this.pos = pos.clone();
        this.prevPos = pos.clone();
    }

    public Vector3 getPosition() {
        return this.pos;
    }

    public void setMotion(Vector3 motion) {
        this.motion = motion;
    }

    public Vector3 getMotion() {
        return this.motion;
    }

    public int getAge() {
        return this.age;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setColor(Color color) {
        this.colorBlue = (float)color.getBlue() / 255.0f;
        this.colorGreen = (float)color.getGreen() / 255.0f;
        this.colorRed = (float)color.getRed() / 255.0f;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public void setGravityMultiplier(float gravityMultiplier) {
        this.gravityMultiplier = gravityMultiplier;
    }

    public void setAlphaMultiplier(float alphaMultiplier) {
        this.alphaMultiplier = alphaMultiplier;
    }

    public float getAlphaMultiplier() {
        return this.alphaMultiplier;
    }

    public void setPositionController(PositionController<EntityFX> positionController) {
        this.positionController = positionController;
    }

    public void setScaleFunction(ScaleFunction<EntityFX> scaleFunction) {
        this.scaleFunction = scaleFunction;
    }

    public void setRefreshFunction(RefreshFunction refreshFunction) {
        this.refreshFunction = refreshFunction;
    }

    public boolean needsRemoval() {
        return this.age >= this.maxAge || this.removeRequested;
    }

    public void tick() {
        ++this.age;
        try {
            if (this.needsRemoval() && this.refreshFunction.shouldRefresh()) {
                this.age = 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.prevPos = this.pos.clone();
        this.pos = this.positionController.updatePosition(this, this.pos, this.motion);
        this.motion.setY(this.motion.getY() * (double)this.gravityMultiplier);
    }

    public boolean isRemoved() {
        return this.flagRemoved;
    }

    public void requestRemoval() {
        this.removeRequested = true;
    }

    public void flagAsRemoved() {
        this.flagRemoved = true;
        this.removeRequested = false;
    }

    public void clearRemoveFlag() {
        this.flagRemoved = false;
    }

    public int getLayer() {
        return 0;
    }

    public static interface PreventRemoval {
    }

    public static interface RefreshFunction {
        public boolean shouldRefresh();
    }

    public static enum AlphaFunction {
        CONSTANT,
        FADE_OUT,
        PYRAMID;


        public float getAlpha(int age, int maxAge) {
            switch (this) {
                case CONSTANT: {
                    return 1.0f;
                }
                case FADE_OUT: {
                    return 1.0f - (float)age / (float)maxAge;
                }
                case PYRAMID: {
                    float halfAge = (float)maxAge / 2.0f;
                    return 1.0f - Math.abs(halfAge - (float)age) / halfAge;
                }
            }
            return 1.0f;
        }
    }

    public static interface ScaleFunction<T extends EntityFX> {
        public float getScale(T var1, float var2, float var3);

        public static class Shrink<T extends EntityFX>
        implements ScaleFunction<T> {
            @Override
            public float getScale(T fx, float pTicks, float scaleIn) {
                float prevAge = Math.max(0.0f, (float)((EntityFX)fx).age - 1.0f) / (float)((EntityFX)fx).maxAge;
                float currAge = Math.max(0.0f, (float)((EntityFX)fx).age) / (float)((EntityFX)fx).maxAge;
                return (float)((double)scaleIn * (1.0 - RenderingUtils.interpolate(prevAge, currAge, pTicks)));
            }
        }
    }

    public static interface PositionController<T extends EntityFX> {
        public Vector3 updatePosition(T var1, Vector3 var2, Vector3 var3);
    }
}

