/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.fracture.client.effect;

import hellfirepvp.fracture.Fracture;
import hellfirepvp.fracture.client.effect.EntityFX;
import hellfirepvp.fracture.client.effect.block.TranslucentFissureFX;
import hellfirepvp.fracture.client.effect.fx.EffectLightning;
import hellfirepvp.fracture.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.fracture.client.texture.AssetLibrary;
import hellfirepvp.fracture.common.data.Config;
import hellfirepvp.fracture.common.util.Vector3;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class EffectHandler {
    public static final Random STATIC_EFFECT_RAND = new Random();
    public static final EffectHandler instance = new EffectHandler();
    private static boolean acceptsNewParticles = true;
    private static boolean cleanRequested = false;
    private static List<EntityFX> toAddBuffer = new LinkedList<EntityFX>();
    public static final Map<Integer, List<EntityFX>> complexEffects = new HashMap<Integer, List<EntityFX>>();
    public static final List<EntityFXFacingParticle> fastRenderParticles = new LinkedList<EntityFXFacingParticle>();
    public static final List<EffectLightning> fastRenderLightnings = new LinkedList<EffectLightning>();

    private EffectHandler() {
    }

    public static EffectHandler getInstance() {
        return instance;
    }

    public static int getDebugEffectCount() {
        int count = 0;
        for (List<EntityFX> eff : complexEffects.values()) {
            count += eff.size();
        }
        count += fastRenderParticles.size();
        return count += fastRenderLightnings.size();
    }

    @SubscribeEvent
    public void onDebugText(RenderGameOverlayEvent.Text event) {
        if (Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            event.getLeft().add("");
            event.getLeft().add(TextFormatting.DARK_PURPLE + "[Fracture]" + TextFormatting.RESET + " EffectHandler:");
            event.getLeft().add(TextFormatting.DARK_PURPLE + "[Fracture]" + TextFormatting.RESET + " > Effects: " + EffectHandler.getDebugEffectCount());
        }
    }

    @SubscribeEvent
    public void onWorldRender(RenderWorldLastEvent event) {
        float partialTicks = event.getPartialTicks();
        EntityFXFacingParticle.renderBatched(partialTicks, fastRenderParticles);
        EffectLightning.renderFast(partialTicks, fastRenderLightnings);
        for (Integer layer : complexEffects.keySet()) {
            for (EntityFX fx : complexEffects.get(layer)) {
                fx.render(partialTicks);
            }
        }
        TranslucentFissureFX.renderBatched(partialTicks);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        this.tick();
    }

    public EntityFX registerFX(EntityFX entityComplexFX) {
        this.registerEffect(entityComplexFX);
        return entityComplexFX;
    }

    public EffectLightning lightning(Vector3 from, Vector3 to) {
        return EffectLightning.buildAndRegisterLightning(from, to);
    }

    private void registerEffect(EntityFX effect) {
        if (AssetLibrary.reloading || effect == null || Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        if (!Thread.currentThread().getName().contains("Client thread")) {
            Fracture.proxy.scheduleClientside(() -> this.registerEffect(effect));
            return;
        }
        if (acceptsNewParticles) {
            this.registerUnsafe(effect);
        } else {
            toAddBuffer.add(effect);
        }
    }

    private void registerUnsafe(EntityFX effect) {
        if (!EffectHandler.mayAcceptParticle(effect)) {
            return;
        }
        if (effect instanceof EntityFXFacingParticle) {
            fastRenderParticles.add((EntityFXFacingParticle)effect);
        } else if (effect instanceof EffectLightning) {
            fastRenderLightnings.add((EffectLightning)effect);
        } else {
            complexEffects.get(effect.getLayer()).add(effect);
        }
        effect.clearRemoveFlag();
    }

    public void tick() {
        if (cleanRequested) {
            for (Integer n : complexEffects.keySet()) {
                List<EntityFX> list = complexEffects.get(n);
                list.forEach(EntityFX::flagAsRemoved);
                list.clear();
            }
            fastRenderParticles.clear();
            fastRenderLightnings.clear();
            toAddBuffer.clear();
            cleanRequested = false;
        }
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        acceptsNewParticles = false;
        for (Integer n : complexEffects.keySet()) {
            Iterator<EntityFX> iterator = complexEffects.get(n).iterator();
            while (iterator.hasNext()) {
                EntityFX effect = iterator.next();
                effect.tick();
                if (!effect.needsRemoval()) continue;
                effect.flagAsRemoved();
                iterator.remove();
            }
        }
        Vector3 playerPos = Vector3.atEntityCenter((Entity)Minecraft.func_71410_x().field_71439_g);
        for (EntityFXFacingParticle entityFXFacingParticle : new ArrayList<EntityFXFacingParticle>(fastRenderParticles)) {
            if (entityFXFacingParticle == null) {
                fastRenderParticles.remove(null);
                continue;
            }
            entityFXFacingParticle.tick();
            if (!entityFXFacingParticle.needsRemoval() && !(entityFXFacingParticle.getPosition().distanceSquared(playerPos) >= (double)Config.maxEffectRenderDistanceSq)) continue;
            entityFXFacingParticle.flagAsRemoved();
            fastRenderParticles.remove(entityFXFacingParticle);
        }
        for (EffectLightning effectLightning : new ArrayList<EffectLightning>(fastRenderLightnings)) {
            if (effectLightning == null) {
                fastRenderLightnings.remove(null);
                continue;
            }
            effectLightning.tick();
            if (!effectLightning.needsRemoval()) continue;
            effectLightning.flagAsRemoved();
            fastRenderLightnings.remove(effectLightning);
        }
        acceptsNewParticles = true;
        LinkedList<EntityFX> linkedList = new LinkedList<EntityFX>(toAddBuffer);
        toAddBuffer.clear();
        for (EntityFX eff : linkedList) {
            this.registerUnsafe(eff);
        }
    }

    public static boolean mayAcceptParticle(EntityFX effect) {
        int cfg = Config.particleAmount;
        if (cfg > 1 && !Minecraft.func_71375_t()) {
            cfg = 1;
        }
        if (effect instanceof EntityFX.PreventRemoval || cfg == 2) {
            return true;
        }
        return cfg == 1 && STATIC_EFFECT_RAND.nextInt(3) == 0;
    }

    public static void cleanUp() {
        cleanRequested = true;
    }

    static {
        for (int i = 0; i <= 5; ++i) {
            complexEffects.put(i, new LinkedList());
        }
    }
}

