/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.fracture.client;

import hellfirepvp.fracture.Fracture;
import hellfirepvp.fracture.client.ClientScheduler;
import hellfirepvp.fracture.client.effect.EffectHandler;
import hellfirepvp.fracture.client.event.ClientEventHandler;
import hellfirepvp.fracture.client.render.tile.TESRFissureDevice;
import hellfirepvp.fracture.client.texture.AssetLibrary;
import hellfirepvp.fracture.common.CommonProxy;
import hellfirepvp.fracture.common.tile.TileFissureDevice;
import hellfirepvp.fracture.common.util.tick.TickManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ClientProxy
extends CommonProxy {
    private final ClientScheduler scheduler = new ClientScheduler();
    private static List<RenderInfoBlock> blockRegister = new ArrayList<RenderInfoBlock>();
    private static List<RenderInfoItem> itemRegister = new ArrayList<RenderInfoItem>();

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        try {
            ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)AssetLibrary.resReloadInstance);
        }
        catch (Exception exc) {
            Fracture.log.warn("[Fracture] Could not add AssetLibrary to resource manager! Texture reloading will have no effect on AstralSorcery textures.");
            AssetLibrary.resReloadInstance.func_110549_a(null);
        }
        super.preInit();
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        this.registerDisplayInformationInit();
        this.registerTileRenderers();
    }

    @Override
    public void init() {
        super.init();
        MinecraftForge.EVENT_BUS.register((Object)EffectHandler.getInstance());
        MinecraftForge.EVENT_BUS.register((Object)ClientEventHandler.INSTANCE);
    }

    @Override
    public void postInit() {
        super.postInit();
    }

    private void registerTileRenderers() {
        this.registerTESR(TileFissureDevice.class, new TESRFissureDevice());
    }

    private <T extends TileEntity> void registerTESR(Class<T> tile, TileEntitySpecialRenderer<T> renderer) {
        ClientRegistry.bindTileEntitySpecialRenderer(tile, renderer);
    }

    @Override
    protected void registerTickHandlers(TickManager manager) {
        super.registerTickHandlers(manager);
        manager.register(this.scheduler);
        manager.register(ClientEventHandler.INSTANCE);
    }

    @Override
    public void scheduleClientside(Runnable r, int tickDelay) {
        this.scheduler.addRunnable(r, tickDelay);
    }

    public void registerDisplayInformationInit() {
        ModelResourceLocation def;
        Item item;
        for (RenderInfoItem renderInfoItem : itemRegister) {
            if (renderInfoItem.variant) {
                this.registerVariantName(renderInfoItem.item, renderInfoItem.name);
            }
            item = renderInfoItem.item;
            def = new ModelResourceLocation("fracture:" + renderInfoItem.name, "inventory");
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)renderInfoItem.metadata, (ModelResourceLocation)def);
        }
        for (RenderInfoBlock renderInfoBlock : blockRegister) {
            item = Item.func_150898_a((Block)renderInfoBlock.block);
            def = new ModelResourceLocation("fracture:" + renderInfoBlock.name, "inventory");
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)renderInfoBlock.metadata, (ModelResourceLocation)def);
        }
    }

    @Override
    public void registerFromSubItems(Item item, String name) {
        NonNullList list = NonNullList.func_191196_a();
        item.func_150895_a(item.func_77640_w(), list);
        if (list.size() > 0) {
            for (ItemStack i : list) {
                this.registerItemRender(item, i.func_77952_i(), name);
            }
        } else {
            this.registerItemRender(item, 0, name);
        }
    }

    @Override
    public void registerVariantName(Item item, String name) {
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("fracture", name)});
    }

    @Override
    public void registerBlockRender(Block block, int metadata, String name) {
        blockRegister.add(new RenderInfoBlock(block, metadata, name));
    }

    @Override
    public void registerItemRender(Item item, int metadata, String name) {
        this.registerItemRender(item, metadata, name, false);
    }

    public void registerItemRender(Item item, int metadata, String name, boolean variant) {
        itemRegister.add(new RenderInfoItem(item, metadata, name, variant));
    }

    private static class RenderInfoItem {
        public Item item;
        public int metadata;
        public String name;
        public boolean variant;

        public RenderInfoItem(Item item, int metadata, String name, boolean variant) {
            this.item = item;
            this.metadata = metadata;
            this.name = name;
            this.variant = variant;
        }
    }

    private static class RenderInfoBlock {
        public Block block;
        public int metadata;
        public String name;

        public RenderInfoBlock(Block block, int metadata, String name) {
            this.block = block;
            this.metadata = metadata;
            this.name = name;
        }
    }
}

