/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.zendarva.tile;

import com.gmail.zendarva.ModBlocks;
import com.gmail.zendarva.RecipeManager;
import com.gmail.zendarva.domain.Research;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class EntityScanner
extends TileEntity
implements ITickable {
    public static final int SIZE = 2;
    public int progress = 0;
    public int maxProgress = 1000;
    public Research currentResearch;
    public ItemStack workingOn = ItemStack.field_190927_a;
    ItemStackHandler inventory = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            EntityScanner.this.func_70296_d();
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("items")) {
            this.inventory.deserializeNBT((NBTTagCompound)compound.func_74781_a("items"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("items", (NBTBase)this.inventory.serializeNBT());
        return compound;
    }

    public void func_73660_a() {
        if (!this.workingOn.func_190926_b() && this.progress < this.maxProgress) {
            ++this.progress;
            return;
        }
        if (this.progress >= this.maxProgress && !this.workingOn.func_190926_b() && this.inventory.getStackInSlot(1).func_190926_b()) {
            this.progress = 0;
            this.maxProgress = 0;
            if (this.func_145831_w().field_72995_K) {
                this.workingOn = ItemStack.field_190927_a;
                return;
            }
            this.inventory.setStackInSlot(1, this.getResearchOutput());
            this.workingOn = ItemStack.field_190927_a;
            return;
        }
        if (this.workingOn.func_190926_b() && !this.inventory.getStackInSlot(0).func_190926_b()) {
            this.workingOn = this.inventory.getStackInSlot(0).func_77946_l();
            this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
            Research research = RecipeManager.getResearchForItem(this.workingOn);
            this.maxProgress = research != null ? research.requiredPower : 1000;
        }
    }

    private ItemStack getResearchOutput() {
        Research research = RecipeManager.getResearchForItem(this.workingOn);
        if (research == null) {
            return ItemStack.field_190927_a;
        }
        Random random = new Random(System.currentTimeMillis());
        if (random.nextInt(100) <= research.successChance) {
            ItemStack stack = new ItemStack((Item)ModBlocks.researchItem);
            ModBlocks.researchItem.setResearch(research, stack);
            return stack;
        }
        return ItemStack.field_190927_a;
    }
}

