/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.zendarva.item;

import com.gmail.zendarva.RecipeManager;
import com.gmail.zendarva.RecipeResearch;
import com.gmail.zendarva.capabilities.ILearnedRecipes;
import com.gmail.zendarva.capabilities.LearnedRecipeProvider;
import com.gmail.zendarva.domain.Research;
import java.util.Optional;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ResearchItem
extends Item {
    public ResearchItem() {
        this.setRegistryName("research");
        this.func_77655_b("reciperesearch.research");
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public String func_77653_i(ItemStack stack) {
        return super.func_77653_i(stack) + " " + this.getMyResearchItemName(stack);
    }

    private String getMyResearch(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            return "Unknown";
        }
        if (stack.func_77978_p().func_74764_b("required")) {
            return stack.func_77978_p().func_74779_i("required");
        }
        return "Unknown";
    }

    private String getMyResearchItemName(ItemStack stack) {
        ItemStack targ = RecipeManager.getStackForName(this.getMyResearch(stack));
        return targ.func_82833_r();
    }

    public void setResearch(Research research, ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p() == null ? new NBTTagCompound() : stack.func_77978_p();
        tag.func_74778_a("required", research.itemToScan);
        stack.func_77982_d(tag);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (this.learnResearch(stack, player)) {
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (worldIn.field_72995_K) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        if (this.learnResearch(stack, player)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
    }

    private boolean learnResearch(ItemStack stack, EntityPlayer player) {
        Optional<Research> oResearch = RecipeResearch.configManager.getResearch(this.getMyResearch(stack));
        if (oResearch.isPresent()) {
            Research research = oResearch.get();
            ILearnedRecipes learnedRecipes = (ILearnedRecipes)player.getCapability(LearnedRecipeProvider.learnedRecipesCapability, null);
            if (learnedRecipes.knowsResearch(research)) {
                player.func_145747_a((ITextComponent)new TextComponentString("You already know about that."));
                return false;
            }
            learnedRecipes.learnResearch(research);
            stack.func_190918_g(1);
            player.func_145747_a((ITextComponent)new TextComponentString("You learn about the applications of " + this.getMyResearchItemName(stack)));
            if (research.commandToRun != null && !player.field_70170_p.field_72995_K) {
                String modifiedCommandToRun = research.commandToRun.replace("%player%", player.func_70005_c_());
                player.field_70170_p.func_73046_m().field_71321_q.func_71556_a((ICommandSender)RecipeResearch.fakePlayer, modifiedCommandToRun);
            }
            return true;
        }
        player.func_145747_a((ITextComponent)new TextComponentString("Something doesn't seem right."));
        return false;
    }
}

