/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.zendarva;

import com.gmail.zendarva.RecipeResearch;
import com.gmail.zendarva.domain.Research;
import com.gmail.zendarva.recipes.LockableRecipe;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;

public class RecipeManager {
    public static List<LockableRecipe> lockedRecipes = new LinkedList<LockableRecipe>();

    public void applyRestrictions() {
        RecipeResearch.configManager.researchList.forEach(this::applyResearch);
    }

    private void applyResearch(Research research) {
        LinkedList<IRecipe> recipesToWrap = new LinkedList<IRecipe>();
        for (String controlledRecipe : research.controlledRecipes) {
            IRecipe target = (IRecipe)ForgeRegistries.RECIPES.getValue(new ResourceLocation(controlledRecipe));
            if (target == null) {
                RecipeResearch.logger.error("Attempting to modify recipe {}, which does not exist.", (Object)controlledRecipe);
                continue;
            }
            recipesToWrap.add(target);
        }
        for (IRecipe recipe : recipesToWrap) {
            RegistryManager.ACTIVE.getRegistry(GameData.RECIPES).remove(recipe.getRegistryName());
            LockableRecipe newRecipe = new LockableRecipe(recipe, research);
            lockedRecipes.add(newRecipe);
            ForgeRegistries.RECIPES.register((IForgeRegistryEntry)newRecipe);
        }
    }

    public static Research getResearchForItem(ItemStack target) {
        for (Research research : RecipeResearch.configManager.researchList) {
            Item item = Item.func_111206_d((String)research.itemToScan);
            if (item == null) {
                return null;
            }
            ItemStack stack = new ItemStack(item);
            if (!stack.func_77969_a(target)) continue;
            return research;
        }
        return null;
    }

    public static ItemStack getStackForName(String name) {
        Item item = Item.func_111206_d((String)name);
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = new ItemStack(item);
        return stack;
    }
}

