/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.zendarva;

import com.gmail.zendarva.RecipeResearch;
import com.gmail.zendarva.domain.Research;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import sun.misc.IOUtils;

public class ConfigManager {
    List<Research> researchList = new LinkedList<Research>();
    Gson gson = new Gson();

    public ConfigManager(File minecraftConfigDir) {
        File myConfigDir = new File(minecraftConfigDir, "recipeResearch");
        if (!myConfigDir.exists()) {
            try {
                RecipeResearch.logger.info("Creating configuration directory and example json");
                this.setupDefaults(myConfigDir);
            }
            catch (IOException e) {
                RecipeResearch.logger.error("Unable to create configuration directory. {}", (Throwable)e);
            }
        }
        try {
            this.readFiles(myConfigDir);
        }
        catch (IOException e) {
            RecipeResearch.logger.error("Unable to load json config files. {}", (Throwable)e);
        }
    }

    public Optional<Research> getResearch(String lockedBehind) {
        return this.researchList.stream().filter(f -> f.itemToScan.toLowerCase().equals(lockedBehind.toLowerCase())).findFirst();
    }

    private void setupDefaults(File myConfigDir) throws IOException {
        Files.createDirectories(myConfigDir.toPath(), new FileAttribute[0]);
        File exampleJson = new File(myConfigDir, "example.json");
        InputStream inStream = ConfigManager.class.getResourceAsStream("/example.json");
        FileOutputStream outStream = new FileOutputStream(exampleJson);
        byte[] fileContent = IOUtils.readFully((InputStream)inStream, (int)-1, (boolean)true);
        ((OutputStream)outStream).write(fileContent);
        ((OutputStream)outStream).close();
    }

    private void readFiles(File myConfigDir) throws IOException {
        Files.list(myConfigDir.toPath()).filter(f -> f.toString().toLowerCase().endsWith(".json")).forEach(this::readJson);
    }

    private void readJson(Path path) {
        File targFile = path.toFile();
        if (targFile.exists() && !targFile.isDirectory()) {
            try {
                List toAdd = (List)this.gson.fromJson((Reader)new FileReader(targFile), new TypeToken<List<Research>>(){}.getType());
                if (toAdd != null) {
                    this.researchList.addAll(toAdd);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }
}

