/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.rcad;

import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.logging.log4j.Logger;
import the_fireplace.rcad.compat.Weather2Compat;

@Mod(modid="rcad", name="Raining Cats and Dogs", version="1.0.0", acceptableRemoteVersions="*", guiFactory="the_fireplace.rcad.client.RCADConfigGui", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public class RainingCatsAndDogs {
    public static final String MODNAME = "Raining Cats and Dogs";
    public static final String MODID = "rcad";
    public static Logger LOGGER = FMLLog.getLogger();

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LOGGER = event.getModLog();
        if (Loader.isModLoaded((String)"weather2")) {
            Weather2Compat compat = new Weather2Compat();
            compat.register();
        } else {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        long time;
        World world = event.player.field_70170_p;
        if (!world.field_72995_K && (time = world.func_82737_E()) % (long)(ConfigValues.time_between_animals * 20) == 0L && world.field_73011_w.func_186058_p() == DimensionType.OVERWORLD && world.func_72911_I()) {
            BlockPos spawnPos = new BlockPos(event.player.func_180425_c().func_177958_n() + world.field_73012_v.nextInt(ConfigValues.animal_spawn_radius * 2) - ConfigValues.animal_spawn_radius, ConfigValues.animal_spawn_height, event.player.func_180425_c().func_177952_p() + world.field_73012_v.nextInt(ConfigValues.animal_spawn_radius * 2) - ConfigValues.animal_spawn_radius);
            if (world.field_73012_v.nextBoolean()) {
                EntityOcelot newCat = new EntityOcelot(world);
                newCat.func_70107_b((double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p());
                world.func_72838_d((Entity)newCat);
                newCat.func_70080_a((double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p(), world.field_73012_v.nextFloat(), world.field_73012_v.nextFloat());
            } else {
                EntityWolf newWolf = new EntityWolf(world);
                newWolf.func_70107_b((double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p());
                world.func_72838_d((Entity)newWolf);
                newWolf.func_70080_a((double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p(), world.field_73012_v.nextFloat(), world.field_73012_v.nextFloat());
                if (ConfigValues.angry_wolves && world.field_73012_v.nextInt(10) != 5) {
                    newWolf.func_70916_h(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void configChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MODID)) {
            ConfigManager.sync((String)MODID, (Config.Type)Config.Type.INSTANCE);
        }
    }

    @Config(modid="rcad")
    public static class ConfigValues {
        @Config.Comment(value={"Time between animals (In seconds)"})
        @Config.LangKey(value="time_between_animals")
        @Config.RangeInt(min=1)
        public static int time_between_animals = 5;
        @Config.Comment(value={"Can wolves be angry about falling from the sky?"})
        @Config.LangKey(value="angry_wolves")
        public static boolean angry_wolves = true;
        @Config.Comment(value={"Animal Spawn Radius around the player"})
        @Config.LangKey(value="animal_spawn_radius")
        @Config.RangeInt(min=1)
        public static int animal_spawn_radius = 64;
        @Config.Comment(value={"Animal Spawn Height"})
        @Config.LangKey(value="animal_spawn_height")
        @Config.RangeInt(min=2)
        public static int animal_spawn_height = 255;
    }
}

