/*
 * Decompiled with CFR 0.152.
 */
package com.github.reallysub.angels.main;

import com.github.reallysub.angels.common.WAObjects;
import com.github.reallysub.angels.common.capability.CapabilityAngelSickness;
import com.github.reallysub.angels.common.capability.IAngelSickness;
import com.github.reallysub.angels.common.events.CommonEvents;
import com.github.reallysub.angels.common.network.MessageSicknessUpdate;
import com.github.reallysub.angels.main.config.Config;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;

@Mod(modid="weeping-angels", name="Weeping Angels", version="5.0", updateJSON="https://www.github.com/ReallySub/Weeping-Angels-Mod/raw/master/update.json", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public class WeepingAngels {
    public static final String MODID = "weeping-angels";
    public static final String NAME = "Weeping Angels";
    public static final String VERSION = "5.0";
    private static Logger logger;
    public static final SimpleNetworkWrapper NETWORK;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Config.init(new Configuration(event.getSuggestedConfigurationFile()));
        logger = event.getModLog();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new CommonEvents());
        WAObjects.setUpSpawns();
        CapabilityManager.INSTANCE.register(IAngelSickness.class, (Capability.IStorage)new CapabilityAngelSickness.Storage(), IAngelSickness.class);
        NETWORK.registerMessage(MessageSicknessUpdate.Handler.class, MessageSicknessUpdate.class, 0, Side.CLIENT);
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ModelResourceLocation loc = new ModelResourceLocation(WAObjects.angelPainting.getRegistryName(), "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)WAObjects.angelPainting, (int)0, (ModelResourceLocation)loc);
        ModelResourceLocation loc2 = new ModelResourceLocation(WAObjects.angelArmItem.getRegistryName(), "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)WAObjects.angelArmItem, (int)0, (ModelResourceLocation)loc2);
    }

    static {
        NETWORK = NetworkRegistry.INSTANCE.newSimpleChannel(MODID);
    }
}

