/*
 * Decompiled with CFR 0.152.
 */
package com.github.reallysub.angels.main;

import com.github.reallysub.angels.common.WAObjects;
import com.github.reallysub.angels.common.capability.CapabilityAngelSickness;
import com.github.reallysub.angels.common.capability.IAngelSickness;
import com.github.reallysub.angels.common.entities.EntityAngel;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class Utils {
    public static int getViewedTicks(EntityPlayer p) {
        return ((IAngelSickness)p.getCapability(CapabilityAngelSickness.CAP, null)).getViewingTicks();
    }

    public static void teleportEntity(World world, Entity e, double X, double Y, double Z) {
        BlockPos p = new BlockPos(X, Y, Z);
        if (world.func_175623_d(p)) {
            if (world.func_180495_p(p.func_177982_a(0, -1, 0)).func_185904_a().func_76220_a()) {
                e.func_70634_a((double)p.func_177958_n(), (double)p.func_177956_o(), (double)p.func_177952_p());
            } else {
                for (int i = 1; i < 255; ++i) {
                    if (!world.func_180495_p(p.func_177982_a(0, -p.func_177956_o() + i - 1, 0)).func_185904_a().func_76220_a()) continue;
                    e.func_70634_a((double)p.func_177958_n(), (double)i, (double)p.func_177952_p());
                }
            }
        } else {
            for (int i = 1; i < 255; ++i) {
                if (!world.func_175623_d(p.func_177982_a(0, -p.func_177956_o() + i, 0)) || !world.func_180495_p(p.func_177982_a(0, -p.func_177956_o() + i - 1, 0)).func_185904_a().func_76220_a()) continue;
                e.func_70634_a((double)p.func_177958_n(), (double)i, (double)p.func_177952_p());
            }
        }
    }

    public static void getAllAngels(EntityPlayer seeker, int distance, double radius) {
        if (distance < 0 || distance > 256) {
            distance = 256;
        }
        Vec3d vec3 = seeker.func_70040_Z();
        double targetX = seeker.field_70165_t;
        double targetY = seeker.field_70163_u + (double)seeker.func_70047_e() - (double)0.1f;
        double targetZ = seeker.field_70161_v;
        double distanceTraveled = 0.0;
        while ((int)distanceTraveled < distance) {
            distanceTraveled += vec3.func_72433_c();
            AxisAlignedBB bb = new AxisAlignedBB((targetX += vec3.field_72450_a) - radius, (targetY += vec3.field_72448_b) - radius, (targetZ += vec3.field_72449_c) - radius, targetX + radius, targetY + radius, targetZ + radius);
            List list = seeker.field_70170_p.func_72872_a(EntityAngel.class, bb);
            IAngelSickness capa = (IAngelSickness)seeker.getCapability(CapabilityAngelSickness.CAP, null);
            if (!list.isEmpty()) {
                for (EntityAngel target : list) {
                    if (!target.func_70067_L() || !Utils.isTargetInSight((EntityLivingBase)seeker, (Entity)target) || seeker.func_70644_a(MobEffects.field_76440_q) || seeker.func_175149_v()) continue;
                    target.setSeen(true);
                    if (target.field_70170_p.field_73012_v.nextInt(5) < 3) {
                        capa.setViewingTicks(capa.getViewingTicks() + 1);
                    }
                    if (target.func_70638_az() != seeker || target.getSeenTime() != 1 || target.field_70170_p.field_73012_v.nextInt(3) != 1) continue;
                    target.func_184185_a(WAObjects.angelSeen, 1.0f, 1.0f);
                }
                continue;
            }
            capa.setViewingTicks(0);
        }
    }

    private static boolean isTargetInSight(EntityLivingBase seeker, Entity target) {
        return seeker.func_70685_l(target) && Utils.isInEyeLine((Entity)seeker, target, 60.0f);
    }

    private static boolean isInEyeLine(Entity seeker, Entity target, float fov) {
        double dx = target.field_70165_t - seeker.field_70165_t;
        double dz = target.field_70161_v - seeker.field_70161_v;
        while (dx * dx + dz * dz < 1.0E-4) {
            dx = (Math.random() - Math.random()) * 0.01;
            dz = (Math.random() - Math.random()) * 0.01;
        }
        while (seeker.field_70177_z > 360.0f) {
            seeker.field_70177_z -= 360.0f;
        }
        while (seeker.field_70177_z < -360.0f) {
            seeker.field_70177_z += 360.0f;
        }
        float yaw = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - seeker.field_70177_z;
        yaw -= 90.0f;
        while (yaw < -180.0f) {
            yaw += 360.0f;
        }
        while (yaw >= 180.0f) {
            yaw -= 360.0f;
        }
        return yaw < fov && yaw > -fov;
    }
}

